/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies demographic information about an endpoint, such as the applicable time zone and platform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointDemographic implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointDemographic.Builder, EndpointDemographic> {
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppVersion").getter(getter(EndpointDemographic::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVersion").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(EndpointDemographic::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> MAKE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Make")
            .getter(getter(EndpointDemographic::make)).setter(setter(Builder::make))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Make").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(EndpointDemographic::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(EndpointDemographic::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(EndpointDemographic::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(EndpointDemographic::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(EndpointDemographic::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSION_FIELD,
            LOCALE_FIELD, MAKE_FIELD, MODEL_FIELD, MODEL_VERSION_FIELD, PLATFORM_FIELD, PLATFORM_VERSION_FIELD, TIMEZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appVersion;

    private final String locale;

    private final String make;

    private final String model;

    private final String modelVersion;

    private final String platform;

    private final String platformVersion;

    private final String timezone;

    private EndpointDemographic(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.locale = builder.locale;
        this.make = builder.make;
        this.model = builder.model;
        this.modelVersion = builder.modelVersion;
        this.platform = builder.platform;
        this.platformVersion = builder.platformVersion;
        this.timezone = builder.timezone;
    }

    /**
     * <p>
     * The version of the app that's associated with the endpoint.
     * </p>
     * 
     * @return The version of the app that's associated with the endpoint.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_),
     * followed by an ISO 3166-1 alpha-2 value.
     * </p>
     * 
     * @return The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an
     *         underscore (_), followed by an ISO 3166-1 alpha-2 value.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * The manufacturer of the endpoint device, such as apple or samsung.
     * </p>
     * 
     * @return The manufacturer of the endpoint device, such as apple or samsung.
     */
    public final String make() {
        return make;
    }

    /**
     * <p>
     * The model name or number of the endpoint device, such as iPhone or SM-G900F.
     * </p>
     * 
     * @return The model name or number of the endpoint device, such as iPhone or SM-G900F.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The model version of the endpoint device.
     * </p>
     * 
     * @return The model version of the endpoint device.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The platform of the endpoint device, such as ios.
     * </p>
     * 
     * @return The platform of the endpoint device, such as ios.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The platform version of the endpoint device.
     * </p>
     * 
     * @return The platform version of the endpoint device.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
     * </p>
     * 
     * @return The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
     */
    public final String timezone() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(make());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDemographic)) {
            return false;
        }
        EndpointDemographic other = (EndpointDemographic) obj;
        return Objects.equals(appVersion(), other.appVersion()) && Objects.equals(locale(), other.locale())
                && Objects.equals(make(), other.make()) && Objects.equals(model(), other.model())
                && Objects.equals(modelVersion(), other.modelVersion()) && Objects.equals(platform(), other.platform())
                && Objects.equals(platformVersion(), other.platformVersion()) && Objects.equals(timezone(), other.timezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointDemographic").add("AppVersion", appVersion()).add("Locale", locale())
                .add("Make", make()).add("Model", model()).add("ModelVersion", modelVersion()).add("Platform", platform())
                .add("PlatformVersion", platformVersion()).add("Timezone", timezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "Make":
            return Optional.ofNullable(clazz.cast(make()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointDemographic, T> g) {
        return obj -> g.apply((EndpointDemographic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointDemographic> {
        /**
         * <p>
         * The version of the app that's associated with the endpoint.
         * </p>
         * 
         * @param appVersion
         *        The version of the app that's associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore
         * (_), followed by an ISO 3166-1 alpha-2 value.
         * </p>
         * 
         * @param locale
         *        The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an
         *        underscore (_), followed by an ISO 3166-1 alpha-2 value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * The manufacturer of the endpoint device, such as apple or samsung.
         * </p>
         * 
         * @param make
         *        The manufacturer of the endpoint device, such as apple or samsung.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder make(String make);

        /**
         * <p>
         * The model name or number of the endpoint device, such as iPhone or SM-G900F.
         * </p>
         * 
         * @param model
         *        The model name or number of the endpoint device, such as iPhone or SM-G900F.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The model version of the endpoint device.
         * </p>
         * 
         * @param modelVersion
         *        The model version of the endpoint device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The platform of the endpoint device, such as ios.
         * </p>
         * 
         * @param platform
         *        The platform of the endpoint device, such as ios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform version of the endpoint device.
         * </p>
         * 
         * @param platformVersion
         *        The platform version of the endpoint device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
         * </p>
         * 
         * @param timezone
         *        The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);
    }

    static final class BuilderImpl implements Builder {
        private String appVersion;

        private String locale;

        private String make;

        private String model;

        private String modelVersion;

        private String platform;

        private String platformVersion;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDemographic model) {
            appVersion(model.appVersion);
            locale(model.locale);
            make(model.make);
            model(model.model);
            modelVersion(model.modelVersion);
            platform(model.platform);
            platformVersion(model.platformVersion);
            timezone(model.timezone);
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getMake() {
            return make;
        }

        public final void setMake(String make) {
            this.make = make;
        }

        @Override
        public final Builder make(String make) {
            this.make = make;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public EndpointDemographic build() {
            return new EndpointDemographic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
