/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the rule settings for when messages can't be sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClosedDaysRule implements SdkPojo, Serializable, ToCopyableBuilder<ClosedDaysRule.Builder, ClosedDaysRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ClosedDaysRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDateTime").getter(getter(ClosedDaysRule::startDateTime)).setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDateTime").getter(getter(ClosedDaysRule::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            START_DATE_TIME_FIELD, END_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String startDateTime;

    private final String endDateTime;

    private ClosedDaysRule(BuilderImpl builder) {
        this.name = builder.name;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * The name of the closed day rule.
     * </p>
     * 
     * @return The name of the closed day rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Start DateTime ISO 8601 format
     * </p>
     * 
     * @return Start DateTime ISO 8601 format
     */
    public final String startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * End DateTime ISO 8601 format
     * </p>
     * 
     * @return End DateTime ISO 8601 format
     */
    public final String endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClosedDaysRule)) {
            return false;
        }
        ClosedDaysRule other = (ClosedDaysRule) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(startDateTime(), other.startDateTime())
                && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClosedDaysRule").add("Name", name()).add("StartDateTime", startDateTime())
                .add("EndDateTime", endDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StartDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClosedDaysRule, T> g) {
        return obj -> g.apply((ClosedDaysRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClosedDaysRule> {
        /**
         * <p>
         * The name of the closed day rule.
         * </p>
         * 
         * @param name
         *        The name of the closed day rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Start DateTime ISO 8601 format
         * </p>
         * 
         * @param startDateTime
         *        Start DateTime ISO 8601 format
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(String startDateTime);

        /**
         * <p>
         * End DateTime ISO 8601 format
         * </p>
         * 
         * @param endDateTime
         *        End DateTime ISO 8601 format
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String startDateTime;

        private String endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClosedDaysRule model) {
            name(model.name);
            startDateTime(model.startDateTime);
            endDateTime(model.endDateTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        @Override
        public ClosedDaysRule build() {
            return new ClosedDaysRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
