/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encryption options for the broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionOptions.Builder, EncryptionOptions> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(EncryptionOptions::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Boolean> USE_AWS_OWNED_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseAwsOwnedKey").getter(getter(EncryptionOptions::useAwsOwnedKey))
            .setter(setter(Builder::useAwsOwnedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAwsOwnedKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            USE_AWS_OWNED_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final Boolean useAwsOwnedKey;

    private EncryptionOptions(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.useAwsOwnedKey = builder.useAwsOwnedKey;
    }

    /**
     * <p>
     * The customer master key (CMK) to use for the A KMS (KMS). This key is used to encrypt your data at rest. If not
     * provided, Amazon MQ will use a default CMK to encrypt your data.
     * </p>
     * 
     * @return The customer master key (CMK) to use for the A KMS (KMS). This key is used to encrypt your data at rest.
     *         If not provided, Amazon MQ will use a default CMK to encrypt your data.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Enables the use of an Amazon Web Services owned CMK using KMS (KMS). Set to true by default, if no value is
     * provided, for example, for RabbitMQ brokers.
     * </p>
     * 
     * @return Enables the use of an Amazon Web Services owned CMK using KMS (KMS). Set to true by default, if no value
     *         is provided, for example, for RabbitMQ brokers.
     */
    public final Boolean useAwsOwnedKey() {
        return useAwsOwnedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(useAwsOwnedKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionOptions)) {
            return false;
        }
        EncryptionOptions other = (EncryptionOptions) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(useAwsOwnedKey(), other.useAwsOwnedKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionOptions").add("KmsKeyId", kmsKeyId()).add("UseAwsOwnedKey", useAwsOwnedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "UseAwsOwnedKey":
            return Optional.ofNullable(clazz.cast(useAwsOwnedKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionOptions, T> g) {
        return obj -> g.apply((EncryptionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionOptions> {
        /**
         * <p>
         * The customer master key (CMK) to use for the A KMS (KMS). This key is used to encrypt your data at rest. If
         * not provided, Amazon MQ will use a default CMK to encrypt your data.
         * </p>
         * 
         * @param kmsKeyId
         *        The customer master key (CMK) to use for the A KMS (KMS). This key is used to encrypt your data at
         *        rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Enables the use of an Amazon Web Services owned CMK using KMS (KMS). Set to true by default, if no value is
         * provided, for example, for RabbitMQ brokers.
         * </p>
         * 
         * @param useAwsOwnedKey
         *        Enables the use of an Amazon Web Services owned CMK using KMS (KMS). Set to true by default, if no
         *        value is provided, for example, for RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAwsOwnedKey(Boolean useAwsOwnedKey);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private Boolean useAwsOwnedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionOptions model) {
            kmsKeyId(model.kmsKeyId);
            useAwsOwnedKey(model.useAwsOwnedKey);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getUseAwsOwnedKey() {
            return useAwsOwnedKey;
        }

        public final void setUseAwsOwnedKey(Boolean useAwsOwnedKey) {
            this.useAwsOwnedKey = useAwsOwnedKey;
        }

        @Override
        public final Builder useAwsOwnedKey(Boolean useAwsOwnedKey) {
            this.useAwsOwnedKey = useAwsOwnedKey;
            return this;
        }

        @Override
        public EncryptionOptions build() {
            return new EncryptionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
