/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationProgressStatus {
    NOT_STARTED("NOT_STARTED"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETED("COMPLETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationProgressStatus> VALUE_MAP;
    private final String value;

    private ApplicationProgressStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationProgressStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationProgressStatus> knownValues() {
        EnumSet<ApplicationProgressStatus> knownValues = EnumSet.allOf(ApplicationProgressStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationProgressStatus.class, ApplicationProgressStatus::toString);
    }
}

