/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Clip range configuration for the VOD source associated with the program.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClipRange implements SdkPojo, Serializable, ToCopyableBuilder<ClipRange.Builder, ClipRange> {
    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EndOffsetMillis").getter(getter(ClipRange::endOffsetMillis)).setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final SdkField<Long> START_OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartOffsetMillis").getter(getter(ClipRange::startOffsetMillis))
            .setter(setter(Builder::startOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartOffsetMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_OFFSET_MILLIS_FIELD,
            START_OFFSET_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long endOffsetMillis;

    private final Long startOffsetMillis;

    private ClipRange(BuilderImpl builder) {
        this.endOffsetMillis = builder.endOffsetMillis;
        this.startOffsetMillis = builder.startOffsetMillis;
    }

    /**
     * <p>
     * The end offset of the clip range, in milliseconds, starting from the beginning of the VOD source associated with
     * the program.
     * </p>
     * 
     * @return The end offset of the clip range, in milliseconds, starting from the beginning of the VOD source
     *         associated with the program.
     */
    public final Long endOffsetMillis() {
        return endOffsetMillis;
    }

    /**
     * <p>
     * The start offset of the clip range, in milliseconds. This offset truncates the start at the number of
     * milliseconds into the duration of the VOD source.
     * </p>
     * 
     * @return The start offset of the clip range, in milliseconds. This offset truncates the start at the number of
     *         milliseconds into the duration of the VOD source.
     */
    public final Long startOffsetMillis() {
        return startOffsetMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(startOffsetMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClipRange)) {
            return false;
        }
        ClipRange other = (ClipRange) obj;
        return Objects.equals(endOffsetMillis(), other.endOffsetMillis())
                && Objects.equals(startOffsetMillis(), other.startOffsetMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClipRange").add("EndOffsetMillis", endOffsetMillis())
                .add("StartOffsetMillis", startOffsetMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        case "StartOffsetMillis":
            return Optional.ofNullable(clazz.cast(startOffsetMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClipRange, T> g) {
        return obj -> g.apply((ClipRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClipRange> {
        /**
         * <p>
         * The end offset of the clip range, in milliseconds, starting from the beginning of the VOD source associated
         * with the program.
         * </p>
         * 
         * @param endOffsetMillis
         *        The end offset of the clip range, in milliseconds, starting from the beginning of the VOD source
         *        associated with the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Long endOffsetMillis);

        /**
         * <p>
         * The start offset of the clip range, in milliseconds. This offset truncates the start at the number of
         * milliseconds into the duration of the VOD source.
         * </p>
         * 
         * @param startOffsetMillis
         *        The start offset of the clip range, in milliseconds. This offset truncates the start at the number of
         *        milliseconds into the duration of the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startOffsetMillis(Long startOffsetMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long endOffsetMillis;

        private Long startOffsetMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(ClipRange model) {
            endOffsetMillis(model.endOffsetMillis);
            startOffsetMillis(model.startOffsetMillis);
        }

        public final Long getEndOffsetMillis() {
            return endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final Long getStartOffsetMillis() {
            return startOffsetMillis;
        }

        public final void setStartOffsetMillis(Long startOffsetMillis) {
            this.startOffsetMillis = startOffsetMillis;
        }

        @Override
        public final Builder startOffsetMillis(Long startOffsetMillis) {
            this.startOffsetMillis = startOffsetMillis;
            return this;
        }

        @Override
        public ClipRange build() {
            return new ClipRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
