/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyDevicePositionResponse extends LocationResponse implements
        ToCopyableBuilder<VerifyDevicePositionResponse.Builder, VerifyDevicePositionResponse> {
    private static final SdkField<InferredState> INFERRED_STATE_FIELD = SdkField
            .<InferredState> builder(MarshallingType.SDK_POJO).memberName("InferredState")
            .getter(getter(VerifyDevicePositionResponse::inferredState)).setter(setter(Builder::inferredState))
            .constructor(InferredState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferredState").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(VerifyDevicePositionResponse::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("SampleTime")
            .getter(getter(VerifyDevicePositionResponse::sampleTime))
            .setter(setter(Builder::sampleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> RECEIVED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReceivedTime")
            .getter(getter(VerifyDevicePositionResponse::receivedTime))
            .setter(setter(Builder::receivedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistanceUnit").getter(getter(VerifyDevicePositionResponse::distanceUnitAsString))
            .setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERRED_STATE_FIELD,
            DEVICE_ID_FIELD, SAMPLE_TIME_FIELD, RECEIVED_TIME_FIELD, DISTANCE_UNIT_FIELD));

    private final InferredState inferredState;

    private final String deviceId;

    private final Instant sampleTime;

    private final Instant receivedTime;

    private final String distanceUnit;

    private VerifyDevicePositionResponse(BuilderImpl builder) {
        super(builder);
        this.inferredState = builder.inferredState;
        this.deviceId = builder.deviceId;
        this.sampleTime = builder.sampleTime;
        this.receivedTime = builder.receivedTime;
        this.distanceUnit = builder.distanceUnit;
    }

    /**
     * <p>
     * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi- access
     * points.
     * </p>
     * 
     * @return The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi-
     *         access points.
     */
    public final InferredState inferredState() {
        return inferredState;
    }

    /**
     * <p>
     * The device identifier.
     * </p>
     * 
     * @return The device identifier.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The timestamp at which the device's position was determined. Uses <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp at which the device's position was determined. Uses <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant sampleTime() {
        return sampleTime;
    }

    /**
     * <p>
     * The timestamp for when the tracker resource received the device position in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the tracker resource received the device position in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant receivedTime() {
        return receivedTime;
    }

    /**
     * <p>
     * The distance unit for the verification response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the verification response.
     * @see DistanceUnit
     */
    public final DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit for the verification response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit for the verification response.
     * @see DistanceUnit
     */
    public final String distanceUnitAsString() {
        return distanceUnit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferredState());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(receivedTime());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDevicePositionResponse)) {
            return false;
        }
        VerifyDevicePositionResponse other = (VerifyDevicePositionResponse) obj;
        return Objects.equals(inferredState(), other.inferredState()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(sampleTime(), other.sampleTime()) && Objects.equals(receivedTime(), other.receivedTime())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyDevicePositionResponse").add("InferredState", inferredState()).add("DeviceId", deviceId())
                .add("SampleTime", sampleTime()).add("ReceivedTime", receivedTime()).add("DistanceUnit", distanceUnitAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferredState":
            return Optional.ofNullable(clazz.cast(inferredState()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "SampleTime":
            return Optional.ofNullable(clazz.cast(sampleTime()));
        case "ReceivedTime":
            return Optional.ofNullable(clazz.cast(receivedTime()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDevicePositionResponse, T> g) {
        return obj -> g.apply((VerifyDevicePositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, VerifyDevicePositionResponse> {
        /**
         * <p>
         * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi-
         * access points.
         * </p>
         * 
         * @param inferredState
         *        The inferred state of the device, given the provided position, IP address, cellular signals, and
         *        Wi-Fi- access points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferredState(InferredState inferredState);

        /**
         * <p>
         * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi-
         * access points.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferredState.Builder} avoiding the need
         * to create one manually via {@link InferredState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferredState.Builder#build()} is called immediately and its
         * result is passed to {@link #inferredState(InferredState)}.
         * 
         * @param inferredState
         *        a consumer that will call methods on {@link InferredState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferredState(InferredState)
         */
        default Builder inferredState(Consumer<InferredState.Builder> inferredState) {
            return inferredState(InferredState.builder().applyMutation(inferredState).build());
        }

        /**
         * <p>
         * The device identifier.
         * </p>
         * 
         * @param deviceId
         *        The device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The timestamp at which the device's position was determined. Uses <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param sampleTime
         *        The timestamp at which the device's position was determined. Uses <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleTime(Instant sampleTime);

        /**
         * <p>
         * The timestamp for when the tracker resource received the device position in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param receivedTime
         *        The timestamp for when the tracker resource received the device position in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedTime(Instant receivedTime);

        /**
         * <p>
         * The distance unit for the verification response.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the verification response.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit for the verification response.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit for the verification response.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private InferredState inferredState;

        private String deviceId;

        private Instant sampleTime;

        private Instant receivedTime;

        private String distanceUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDevicePositionResponse model) {
            super(model);
            inferredState(model.inferredState);
            deviceId(model.deviceId);
            sampleTime(model.sampleTime);
            receivedTime(model.receivedTime);
            distanceUnit(model.distanceUnit);
        }

        public final InferredState.Builder getInferredState() {
            return inferredState != null ? inferredState.toBuilder() : null;
        }

        public final void setInferredState(InferredState.BuilderImpl inferredState) {
            this.inferredState = inferredState != null ? inferredState.build() : null;
        }

        @Override
        public final Builder inferredState(InferredState inferredState) {
            this.inferredState = inferredState;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Instant getSampleTime() {
            return sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public final Instant getReceivedTime() {
            return receivedTime;
        }

        public final void setReceivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
        }

        @Override
        public final Builder receivedTime(Instant receivedTime) {
            this.receivedTime = receivedTime;
            return this;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        @Override
        public VerifyDevicePositionResponse build() {
            return new VerifyDevicePositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
