/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets information about a Sidewalk device profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SidewalkGetDeviceProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<SidewalkGetDeviceProfile.Builder, SidewalkGetDeviceProfile> {
    private static final SdkField<String> APPLICATION_SERVER_PUBLIC_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationServerPublicKey")
            .getter(getter(SidewalkGetDeviceProfile::applicationServerPublicKey))
            .setter(setter(Builder::applicationServerPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationServerPublicKey").build())
            .build();

    private static final SdkField<Boolean> QUALIFICATION_STATUS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("QualificationStatus").getter(getter(SidewalkGetDeviceProfile::qualificationStatus))
            .setter(setter(Builder::qualificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationStatus").build())
            .build();

    private static final SdkField<List<DakCertificateMetadata>> DAK_CERTIFICATE_METADATA_FIELD = SdkField
            .<List<DakCertificateMetadata>> builder(MarshallingType.LIST)
            .memberName("DakCertificateMetadata")
            .getter(getter(SidewalkGetDeviceProfile::dakCertificateMetadata))
            .setter(setter(Builder::dakCertificateMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DakCertificateMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DakCertificateMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DakCertificateMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_SERVER_PUBLIC_KEY_FIELD, QUALIFICATION_STATUS_FIELD, DAK_CERTIFICATE_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationServerPublicKey;

    private final Boolean qualificationStatus;

    private final List<DakCertificateMetadata> dakCertificateMetadata;

    private SidewalkGetDeviceProfile(BuilderImpl builder) {
        this.applicationServerPublicKey = builder.applicationServerPublicKey;
        this.qualificationStatus = builder.qualificationStatus;
        this.dakCertificateMetadata = builder.dakCertificateMetadata;
    }

    /**
     * <p>
     * The Sidewalk application server public key.
     * </p>
     * 
     * @return The Sidewalk application server public key.
     */
    public final String applicationServerPublicKey() {
        return applicationServerPublicKey;
    }

    /**
     * <p>
     * Gets information about the certification status of a Sidewalk device profile.
     * </p>
     * 
     * @return Gets information about the certification status of a Sidewalk device profile.
     */
    public final Boolean qualificationStatus() {
        return qualificationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the DakCertificateMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDakCertificateMetadata() {
        return dakCertificateMetadata != null && !(dakCertificateMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DAK certificate information of the Sidewalk device profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDakCertificateMetadata} method.
     * </p>
     * 
     * @return The DAK certificate information of the Sidewalk device profile.
     */
    public final List<DakCertificateMetadata> dakCertificateMetadata() {
        return dakCertificateMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationServerPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(qualificationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasDakCertificateMetadata() ? dakCertificateMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkGetDeviceProfile)) {
            return false;
        }
        SidewalkGetDeviceProfile other = (SidewalkGetDeviceProfile) obj;
        return Objects.equals(applicationServerPublicKey(), other.applicationServerPublicKey())
                && Objects.equals(qualificationStatus(), other.qualificationStatus())
                && hasDakCertificateMetadata() == other.hasDakCertificateMetadata()
                && Objects.equals(dakCertificateMetadata(), other.dakCertificateMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SidewalkGetDeviceProfile")
                .add("ApplicationServerPublicKey",
                        applicationServerPublicKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QualificationStatus", qualificationStatus())
                .add("DakCertificateMetadata", hasDakCertificateMetadata() ? dakCertificateMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationServerPublicKey":
            return Optional.ofNullable(clazz.cast(applicationServerPublicKey()));
        case "QualificationStatus":
            return Optional.ofNullable(clazz.cast(qualificationStatus()));
        case "DakCertificateMetadata":
            return Optional.ofNullable(clazz.cast(dakCertificateMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkGetDeviceProfile, T> g) {
        return obj -> g.apply((SidewalkGetDeviceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SidewalkGetDeviceProfile> {
        /**
         * <p>
         * The Sidewalk application server public key.
         * </p>
         * 
         * @param applicationServerPublicKey
         *        The Sidewalk application server public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationServerPublicKey(String applicationServerPublicKey);

        /**
         * <p>
         * Gets information about the certification status of a Sidewalk device profile.
         * </p>
         * 
         * @param qualificationStatus
         *        Gets information about the certification status of a Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationStatus(Boolean qualificationStatus);

        /**
         * <p>
         * The DAK certificate information of the Sidewalk device profile.
         * </p>
         * 
         * @param dakCertificateMetadata
         *        The DAK certificate information of the Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dakCertificateMetadata(Collection<DakCertificateMetadata> dakCertificateMetadata);

        /**
         * <p>
         * The DAK certificate information of the Sidewalk device profile.
         * </p>
         * 
         * @param dakCertificateMetadata
         *        The DAK certificate information of the Sidewalk device profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dakCertificateMetadata(DakCertificateMetadata... dakCertificateMetadata);

        /**
         * <p>
         * The DAK certificate information of the Sidewalk device profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #dakCertificateMetadata(List<DakCertificateMetadata>)}.
         * 
         * @param dakCertificateMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dakCertificateMetadata(java.util.Collection<DakCertificateMetadata>)
         */
        Builder dakCertificateMetadata(Consumer<DakCertificateMetadata.Builder>... dakCertificateMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String applicationServerPublicKey;

        private Boolean qualificationStatus;

        private List<DakCertificateMetadata> dakCertificateMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkGetDeviceProfile model) {
            applicationServerPublicKey(model.applicationServerPublicKey);
            qualificationStatus(model.qualificationStatus);
            dakCertificateMetadata(model.dakCertificateMetadata);
        }

        public final String getApplicationServerPublicKey() {
            return applicationServerPublicKey;
        }

        public final void setApplicationServerPublicKey(String applicationServerPublicKey) {
            this.applicationServerPublicKey = applicationServerPublicKey;
        }

        @Override
        public final Builder applicationServerPublicKey(String applicationServerPublicKey) {
            this.applicationServerPublicKey = applicationServerPublicKey;
            return this;
        }

        public final Boolean getQualificationStatus() {
            return qualificationStatus;
        }

        public final void setQualificationStatus(Boolean qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
        }

        @Override
        public final Builder qualificationStatus(Boolean qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
            return this;
        }

        public final List<DakCertificateMetadata.Builder> getDakCertificateMetadata() {
            List<DakCertificateMetadata.Builder> result = DakCertificateMetadataListCopier
                    .copyToBuilder(this.dakCertificateMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDakCertificateMetadata(Collection<DakCertificateMetadata.BuilderImpl> dakCertificateMetadata) {
            this.dakCertificateMetadata = DakCertificateMetadataListCopier.copyFromBuilder(dakCertificateMetadata);
        }

        @Override
        public final Builder dakCertificateMetadata(Collection<DakCertificateMetadata> dakCertificateMetadata) {
            this.dakCertificateMetadata = DakCertificateMetadataListCopier.copy(dakCertificateMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dakCertificateMetadata(DakCertificateMetadata... dakCertificateMetadata) {
            dakCertificateMetadata(Arrays.asList(dakCertificateMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dakCertificateMetadata(Consumer<DakCertificateMetadata.Builder>... dakCertificateMetadata) {
            dakCertificateMetadata(Stream.of(dakCertificateMetadata)
                    .map(c -> DakCertificateMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SidewalkGetDeviceProfile build() {
            return new SidewalkGetDeviceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
