/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceProfilesRequest extends IotWirelessRequest implements
        ToCopyableBuilder<ListDeviceProfilesRequest.Builder, ListDeviceProfilesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeviceProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDeviceProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> DEVICE_PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceProfileType").getter(getter(ListDeviceProfilesRequest::deviceProfileTypeAsString))
            .setter(setter(Builder::deviceProfileType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceProfileType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, DEVICE_PROFILE_TYPE_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String deviceProfileType;

    private ListDeviceProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.deviceProfileType = builder.deviceProfileType;
    }

    /**
     * <p>
     * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     * <b>null</b> to receive the first set of results.
     * </p>
     * 
     * @return To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
     *         <b>null</b> to receive the first set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in this operation.
     * </p>
     * 
     * @return The maximum number of results to return in this operation.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
     * <code>Sidewalk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceProfileType}
     * will return {@link DeviceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deviceProfileTypeAsString}.
     * </p>
     * 
     * @return A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
     *         <code>Sidewalk</code>.
     * @see DeviceProfileType
     */
    public final DeviceProfileType deviceProfileType() {
        return DeviceProfileType.fromValue(deviceProfileType);
    }

    /**
     * <p>
     * A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
     * <code>Sidewalk</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceProfileType}
     * will return {@link DeviceProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deviceProfileTypeAsString}.
     * </p>
     * 
     * @return A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
     *         <code>Sidewalk</code>.
     * @see DeviceProfileType
     */
    public final String deviceProfileTypeAsString() {
        return deviceProfileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(deviceProfileTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceProfilesRequest)) {
            return false;
        }
        ListDeviceProfilesRequest other = (ListDeviceProfilesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(deviceProfileTypeAsString(), other.deviceProfileTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceProfilesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("DeviceProfileType", deviceProfileTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DeviceProfileType":
            return Optional.ofNullable(clazz.cast(deviceProfileTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceProfilesRequest, T> g) {
        return obj -> g.apply((ListDeviceProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeviceProfilesRequest> {
        /**
         * <p>
         * To retrieve the next set of results, the <code>nextToken</code> value from a previous response; otherwise
         * <b>null</b> to receive the first set of results.
         * </p>
         * 
         * @param nextToken
         *        To retrieve the next set of results, the <code>nextToken</code> value from a previous response;
         *        otherwise <b>null</b> to receive the first set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in this operation.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
         * <code>Sidewalk</code>.
         * </p>
         * 
         * @param deviceProfileType
         *        A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
         *        <code>Sidewalk</code>.
         * @see DeviceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceProfileType
         */
        Builder deviceProfileType(String deviceProfileType);

        /**
         * <p>
         * A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
         * <code>Sidewalk</code>.
         * </p>
         * 
         * @param deviceProfileType
         *        A filter to list only device profiles that use this type, which can be <code>LoRaWAN</code> or
         *        <code>Sidewalk</code>.
         * @see DeviceProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceProfileType
         */
        Builder deviceProfileType(DeviceProfileType deviceProfileType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String deviceProfileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceProfilesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            deviceProfileType(model.deviceProfileType);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDeviceProfileType() {
            return deviceProfileType;
        }

        public final void setDeviceProfileType(String deviceProfileType) {
            this.deviceProfileType = deviceProfileType;
        }

        @Override
        public final Builder deviceProfileType(String deviceProfileType) {
            this.deviceProfileType = deviceProfileType;
            return this;
        }

        @Override
        public final Builder deviceProfileType(DeviceProfileType deviceProfileType) {
            this.deviceProfileType(deviceProfileType == null ? null : deviceProfileType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceProfilesRequest build() {
            return new ListDeviceProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
