/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDestinationResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetDestinationResponse.Builder, GetDestinationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetDestinationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetDestinationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(GetDestinationResponse::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> EXPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpressionType").getter(getter(GetDestinationResponse::expressionTypeAsString))
            .setter(setter(Builder::expressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetDestinationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GetDestinationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            EXPRESSION_FIELD, EXPRESSION_TYPE_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD));

    private final String arn;

    private final String name;

    private final String expression;

    private final String expressionType;

    private final String description;

    private final String roleArn;

    private GetDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.expression = builder.expression;
        this.expressionType = builder.expressionType;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The rule name or topic rule to send messages to.
     * </p>
     * 
     * @return The rule name or topic rule to send messages to.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The type of value in <code>Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expressionType}
     * will return {@link ExpressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expressionTypeAsString}.
     * </p>
     * 
     * @return The type of value in <code>Expression</code>.
     * @see ExpressionType
     */
    public final ExpressionType expressionType() {
        return ExpressionType.fromValue(expressionType);
    }

    /**
     * <p>
     * The type of value in <code>Expression</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #expressionType}
     * will return {@link ExpressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expressionTypeAsString}.
     * </p>
     * 
     * @return The type of value in <code>Expression</code>.
     * @see ExpressionType
     */
    public final String expressionTypeAsString() {
        return expressionType;
    }

    /**
     * <p>
     * The description of the resource.
     * </p>
     * 
     * @return The description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the IAM Role that authorizes the destination.
     * </p>
     * 
     * @return The ARN of the IAM Role that authorizes the destination.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDestinationResponse)) {
            return false;
        }
        GetDestinationResponse other = (GetDestinationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(expression(), other.expression())
                && Objects.equals(expressionTypeAsString(), other.expressionTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDestinationResponse").add("Arn", arn()).add("Name", name()).add("Expression", expression())
                .add("ExpressionType", expressionTypeAsString()).add("Description", description()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "ExpressionType":
            return Optional.ofNullable(clazz.cast(expressionTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDestinationResponse, T> g) {
        return obj -> g.apply((GetDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDestinationResponse> {
        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The rule name or topic rule to send messages to.
         * </p>
         * 
         * @param expression
         *        The rule name or topic rule to send messages to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The type of value in <code>Expression</code>.
         * </p>
         * 
         * @param expressionType
         *        The type of value in <code>Expression</code>.
         * @see ExpressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpressionType
         */
        Builder expressionType(String expressionType);

        /**
         * <p>
         * The type of value in <code>Expression</code>.
         * </p>
         * 
         * @param expressionType
         *        The type of value in <code>Expression</code>.
         * @see ExpressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpressionType
         */
        Builder expressionType(ExpressionType expressionType);

        /**
         * <p>
         * The description of the resource.
         * </p>
         * 
         * @param description
         *        The description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the IAM Role that authorizes the destination.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM Role that authorizes the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String expression;

        private String expressionType;

        private String description;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDestinationResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            expression(model.expression);
            expressionType(model.expressionType);
            description(model.description);
            roleArn(model.roleArn);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getExpressionType() {
            return expressionType;
        }

        public final void setExpressionType(String expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public final Builder expressionType(String expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        @Override
        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType(expressionType == null ? null : expressionType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public GetDestinationResponse build() {
            return new GetDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
