/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used in the <a>AssessmentTemplateFilter</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DurationRange implements SdkPojo, Serializable, ToCopyableBuilder<DurationRange.Builder, DurationRange> {
    private static final SdkField<Integer> MIN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minSeconds").getter(getter(DurationRange::minSeconds)).setter(setter(Builder::minSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSeconds").build()).build();

    private static final SdkField<Integer> MAX_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSeconds").getter(getter(DurationRange::maxSeconds)).setter(setter(Builder::maxSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SECONDS_FIELD,
            MAX_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minSeconds;

    private final Integer maxSeconds;

    private DurationRange(BuilderImpl builder) {
        this.minSeconds = builder.minSeconds;
        this.maxSeconds = builder.maxSeconds;
    }

    /**
     * <p>
     * The minimum value of the duration range. Must be greater than zero.
     * </p>
     * 
     * @return The minimum value of the duration range. Must be greater than zero.
     */
    public final Integer minSeconds() {
        return minSeconds;
    }

    /**
     * <p>
     * The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
     * </p>
     * 
     * @return The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
     */
    public final Integer maxSeconds() {
        return maxSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DurationRange)) {
            return false;
        }
        DurationRange other = (DurationRange) obj;
        return Objects.equals(minSeconds(), other.minSeconds()) && Objects.equals(maxSeconds(), other.maxSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DurationRange").add("MinSeconds", minSeconds()).add("MaxSeconds", maxSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minSeconds":
            return Optional.ofNullable(clazz.cast(minSeconds()));
        case "maxSeconds":
            return Optional.ofNullable(clazz.cast(maxSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DurationRange, T> g) {
        return obj -> g.apply((DurationRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DurationRange> {
        /**
         * <p>
         * The minimum value of the duration range. Must be greater than zero.
         * </p>
         * 
         * @param minSeconds
         *        The minimum value of the duration range. Must be greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSeconds(Integer minSeconds);

        /**
         * <p>
         * The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
         * </p>
         * 
         * @param maxSeconds
         *        The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSeconds(Integer maxSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer minSeconds;

        private Integer maxSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DurationRange model) {
            minSeconds(model.minSeconds);
            maxSeconds(model.maxSeconds);
        }

        public final Integer getMinSeconds() {
            return minSeconds;
        }

        public final void setMinSeconds(Integer minSeconds) {
            this.minSeconds = minSeconds;
        }

        @Override
        public final Builder minSeconds(Integer minSeconds) {
            this.minSeconds = minSeconds;
            return this;
        }

        public final Integer getMaxSeconds() {
            return maxSeconds;
        }

        public final void setMaxSeconds(Integer maxSeconds) {
            this.maxSeconds = maxSeconds;
        }

        @Override
        public final Builder maxSeconds(Integer maxSeconds) {
            this.maxSeconds = maxSeconds;
            return this;
        }

        @Override
        public DurationRange build() {
            return new DurationRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
