/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains EBS volume details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeDetail implements SdkPojo, Serializable, ToCopyableBuilder<VolumeDetail.Builder, VolumeDetail> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeArn").getter(getter(VolumeDetail::volumeArn)).setter(setter(Builder::volumeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArn").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(VolumeDetail::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(VolumeDetail::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(VolumeDetail::volumeSizeInGB)).setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGB").build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(VolumeDetail::encryptionType)).setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotArn").getter(getter(VolumeDetail::snapshotArn)).setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(VolumeDetail::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            VOLUME_TYPE_FIELD, DEVICE_NAME_FIELD, VOLUME_SIZE_IN_GB_FIELD, ENCRYPTION_TYPE_FIELD, SNAPSHOT_ARN_FIELD,
            KMS_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeArn;

    private final String volumeType;

    private final String deviceName;

    private final Integer volumeSizeInGB;

    private final String encryptionType;

    private final String snapshotArn;

    private final String kmsKeyArn;

    private VolumeDetail(BuilderImpl builder) {
        this.volumeArn = builder.volumeArn;
        this.volumeType = builder.volumeType;
        this.deviceName = builder.deviceName;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.encryptionType = builder.encryptionType;
        this.snapshotArn = builder.snapshotArn;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * EBS volume ARN information.
     * </p>
     * 
     * @return EBS volume ARN information.
     */
    public final String volumeArn() {
        return volumeArn;
    }

    /**
     * <p>
     * The EBS volume type.
     * </p>
     * 
     * @return The EBS volume type.
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * The device name for the EBS volume.
     * </p>
     * 
     * @return The device name for the EBS volume.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * EBS volume size in GB.
     * </p>
     * 
     * @return EBS volume size in GB.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * EBS volume encryption type.
     * </p>
     * 
     * @return EBS volume encryption type.
     */
    public final String encryptionType() {
        return encryptionType;
    }

    /**
     * <p>
     * Snapshot ARN of the EBS volume.
     * </p>
     * 
     * @return Snapshot ARN of the EBS volume.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * KMS key ARN used to encrypt the EBS volume.
     * </p>
     * 
     * @return KMS key ARN used to encrypt the EBS volume.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeArn());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeDetail)) {
            return false;
        }
        VolumeDetail other = (VolumeDetail) obj;
        return Objects.equals(volumeArn(), other.volumeArn()) && Objects.equals(volumeType(), other.volumeType())
                && Objects.equals(deviceName(), other.deviceName()) && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && Objects.equals(encryptionType(), other.encryptionType()) && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeDetail").add("VolumeArn", volumeArn()).add("VolumeType", volumeType())
                .add("DeviceName", deviceName()).add("VolumeSizeInGB", volumeSizeInGB()).add("EncryptionType", encryptionType())
                .add("SnapshotArn", snapshotArn()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeArn":
            return Optional.ofNullable(clazz.cast(volumeArn()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionType()));
        case "SnapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeDetail, T> g) {
        return obj -> g.apply((VolumeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeDetail> {
        /**
         * <p>
         * EBS volume ARN information.
         * </p>
         * 
         * @param volumeArn
         *        EBS volume ARN information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeArn(String volumeArn);

        /**
         * <p>
         * The EBS volume type.
         * </p>
         * 
         * @param volumeType
         *        The EBS volume type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The device name for the EBS volume.
         * </p>
         * 
         * @param deviceName
         *        The device name for the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * EBS volume size in GB.
         * </p>
         * 
         * @param volumeSizeInGB
         *        EBS volume size in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * EBS volume encryption type.
         * </p>
         * 
         * @param encryptionType
         *        EBS volume encryption type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * Snapshot ARN of the EBS volume.
         * </p>
         * 
         * @param snapshotArn
         *        Snapshot ARN of the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * KMS key ARN used to encrypt the EBS volume.
         * </p>
         * 
         * @param kmsKeyArn
         *        KMS key ARN used to encrypt the EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String volumeArn;

        private String volumeType;

        private String deviceName;

        private Integer volumeSizeInGB;

        private String encryptionType;

        private String snapshotArn;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeDetail model) {
            volumeArn(model.volumeArn);
            volumeType(model.volumeType);
            deviceName(model.deviceName);
            volumeSizeInGB(model.volumeSizeInGB);
            encryptionType(model.encryptionType);
            snapshotArn(model.snapshotArn);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getVolumeArn() {
            return volumeArn;
        }

        public final void setVolumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
        }

        @Override
        public final Builder volumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public VolumeDetail build() {
            return new VolumeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
