/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of GuardDuty usage. If a UsageStatisticType is provided the result for other types will be null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageStatistics implements SdkPojo, Serializable, ToCopyableBuilder<UsageStatistics.Builder, UsageStatistics> {
    private static final SdkField<List<UsageAccountResult>> SUM_BY_ACCOUNT_FIELD = SdkField
            .<List<UsageAccountResult>> builder(MarshallingType.LIST)
            .memberName("SumByAccount")
            .getter(getter(UsageStatistics::sumByAccount))
            .setter(setter(Builder::sumByAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByAccount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageAccountResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageAccountResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageTopAccountsResult>> TOP_ACCOUNTS_BY_FEATURE_FIELD = SdkField
            .<List<UsageTopAccountsResult>> builder(MarshallingType.LIST)
            .memberName("TopAccountsByFeature")
            .getter(getter(UsageStatistics::topAccountsByFeature))
            .setter(setter(Builder::topAccountsByFeature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topAccountsByFeature").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageTopAccountsResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageTopAccountsResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageDataSourceResult>> SUM_BY_DATA_SOURCE_FIELD = SdkField
            .<List<UsageDataSourceResult>> builder(MarshallingType.LIST)
            .memberName("SumByDataSource")
            .getter(getter(UsageStatistics::sumByDataSource))
            .setter(setter(Builder::sumByDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByDataSource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageDataSourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageDataSourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageResourceResult>> SUM_BY_RESOURCE_FIELD = SdkField
            .<List<UsageResourceResult>> builder(MarshallingType.LIST)
            .memberName("SumByResource")
            .getter(getter(UsageStatistics::sumByResource))
            .setter(setter(Builder::sumByResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByResource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageResourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageResourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageResourceResult>> TOP_RESOURCES_FIELD = SdkField
            .<List<UsageResourceResult>> builder(MarshallingType.LIST)
            .memberName("TopResources")
            .getter(getter(UsageStatistics::topResources))
            .setter(setter(Builder::topResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageResourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageResourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UsageFeatureResult>> SUM_BY_FEATURE_FIELD = SdkField
            .<List<UsageFeatureResult>> builder(MarshallingType.LIST)
            .memberName("SumByFeature")
            .getter(getter(UsageStatistics::sumByFeature))
            .setter(setter(Builder::sumByFeature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumByFeature").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageFeatureResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageFeatureResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUM_BY_ACCOUNT_FIELD,
            TOP_ACCOUNTS_BY_FEATURE_FIELD, SUM_BY_DATA_SOURCE_FIELD, SUM_BY_RESOURCE_FIELD, TOP_RESOURCES_FIELD,
            SUM_BY_FEATURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<UsageAccountResult> sumByAccount;

    private final List<UsageTopAccountsResult> topAccountsByFeature;

    private final List<UsageDataSourceResult> sumByDataSource;

    private final List<UsageResourceResult> sumByResource;

    private final List<UsageResourceResult> topResources;

    private final List<UsageFeatureResult> sumByFeature;

    private UsageStatistics(BuilderImpl builder) {
        this.sumByAccount = builder.sumByAccount;
        this.topAccountsByFeature = builder.topAccountsByFeature;
        this.sumByDataSource = builder.sumByDataSource;
        this.sumByResource = builder.sumByResource;
        this.topResources = builder.topResources;
        this.sumByFeature = builder.sumByFeature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SumByAccount property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSumByAccount() {
        return sumByAccount != null && !(sumByAccount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by account ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSumByAccount} method.
     * </p>
     * 
     * @return The usage statistic sum organized by account ID.
     */
    public final List<UsageAccountResult> sumByAccount() {
        return sumByAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopAccountsByFeature property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopAccountsByFeature() {
        return topAccountsByFeature != null && !(topAccountsByFeature instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most to
     * least expensive.
     * </p>
     * <p>
     * Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopAccountsByFeature} method.
     * </p>
     * 
     * @return Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most
     *         to least expensive.</p>
     *         <p>
     *         Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
     */
    public final List<UsageTopAccountsResult> topAccountsByFeature() {
        return topAccountsByFeature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SumByDataSource property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSumByDataSource() {
        return sumByDataSource != null && !(sumByDataSource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by on data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSumByDataSource} method.
     * </p>
     * 
     * @return The usage statistic sum organized by on data source.
     */
    public final List<UsageDataSourceResult> sumByDataSource() {
        return sumByDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the SumByResource property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSumByResource() {
        return sumByResource != null && !(sumByResource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSumByResource} method.
     * </p>
     * 
     * @return The usage statistic sum organized by resource.
     */
    public final List<UsageResourceResult> sumByResource() {
        return sumByResource;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopResources() {
        return topResources != null && !(topResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least expensive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopResources} method.
     * </p>
     * 
     * @return Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
     *         expensive.
     */
    public final List<UsageResourceResult> topResources() {
        return topResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the SumByFeature property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSumByFeature() {
        return sumByFeature != null && !(sumByFeature instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage statistic sum organized by feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSumByFeature} method.
     * </p>
     * 
     * @return The usage statistic sum organized by feature.
     */
    public final List<UsageFeatureResult> sumByFeature() {
        return sumByFeature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByAccount() ? sumByAccount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopAccountsByFeature() ? topAccountsByFeature() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByDataSource() ? sumByDataSource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByResource() ? sumByResource() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTopResources() ? topResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSumByFeature() ? sumByFeature() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageStatistics)) {
            return false;
        }
        UsageStatistics other = (UsageStatistics) obj;
        return hasSumByAccount() == other.hasSumByAccount() && Objects.equals(sumByAccount(), other.sumByAccount())
                && hasTopAccountsByFeature() == other.hasTopAccountsByFeature()
                && Objects.equals(topAccountsByFeature(), other.topAccountsByFeature())
                && hasSumByDataSource() == other.hasSumByDataSource()
                && Objects.equals(sumByDataSource(), other.sumByDataSource()) && hasSumByResource() == other.hasSumByResource()
                && Objects.equals(sumByResource(), other.sumByResource()) && hasTopResources() == other.hasTopResources()
                && Objects.equals(topResources(), other.topResources()) && hasSumByFeature() == other.hasSumByFeature()
                && Objects.equals(sumByFeature(), other.sumByFeature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageStatistics").add("SumByAccount", hasSumByAccount() ? sumByAccount() : null)
                .add("TopAccountsByFeature", hasTopAccountsByFeature() ? topAccountsByFeature() : null)
                .add("SumByDataSource", hasSumByDataSource() ? sumByDataSource() : null)
                .add("SumByResource", hasSumByResource() ? sumByResource() : null)
                .add("TopResources", hasTopResources() ? topResources() : null)
                .add("SumByFeature", hasSumByFeature() ? sumByFeature() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SumByAccount":
            return Optional.ofNullable(clazz.cast(sumByAccount()));
        case "TopAccountsByFeature":
            return Optional.ofNullable(clazz.cast(topAccountsByFeature()));
        case "SumByDataSource":
            return Optional.ofNullable(clazz.cast(sumByDataSource()));
        case "SumByResource":
            return Optional.ofNullable(clazz.cast(sumByResource()));
        case "TopResources":
            return Optional.ofNullable(clazz.cast(topResources()));
        case "SumByFeature":
            return Optional.ofNullable(clazz.cast(sumByFeature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageStatistics, T> g) {
        return obj -> g.apply((UsageStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageStatistics> {
        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * 
         * @param sumByAccount
         *        The usage statistic sum organized by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByAccount(Collection<UsageAccountResult> sumByAccount);

        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * 
         * @param sumByAccount
         *        The usage statistic sum organized by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByAccount(UsageAccountResult... sumByAccount);

        /**
         * <p>
         * The usage statistic sum organized by account ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageAccountResult.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.UsageAccountResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageAccountResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sumByAccount(List<UsageAccountResult>)}.
         * 
         * @param sumByAccount
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageAccountResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByAccount(java.util.Collection<UsageAccountResult>)
         */
        Builder sumByAccount(Consumer<UsageAccountResult.Builder>... sumByAccount);

        /**
         * <p>
         * Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most to
         * least expensive.
         * </p>
         * <p>
         * Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
         * </p>
         * 
         * @param topAccountsByFeature
         *        Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from
         *        most to least expensive.</p>
         *        <p>
         *        Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAccountsByFeature(Collection<UsageTopAccountsResult> topAccountsByFeature);

        /**
         * <p>
         * Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most to
         * least expensive.
         * </p>
         * <p>
         * Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
         * </p>
         * 
         * @param topAccountsByFeature
         *        Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from
         *        most to least expensive.</p>
         *        <p>
         *        Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topAccountsByFeature(UsageTopAccountsResult... topAccountsByFeature);

        /**
         * <p>
         * Lists the top 50 accounts by feature that have generated the most GuardDuty usage, in the order from most to
         * least expensive.
         * </p>
         * <p>
         * Currently, this doesn't support <code>RDS_LOGIN_EVENTS</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResult.Builder#build()} is called
         * immediately and its result is passed to {@link #topAccountsByFeature(List<UsageTopAccountsResult>)}.
         * 
         * @param topAccountsByFeature
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageTopAccountsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topAccountsByFeature(java.util.Collection<UsageTopAccountsResult>)
         */
        Builder topAccountsByFeature(Consumer<UsageTopAccountsResult.Builder>... topAccountsByFeature);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * 
         * @param sumByDataSource
         *        The usage statistic sum organized by on data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * 
         * @param sumByDataSource
         *        The usage statistic sum organized by on data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByDataSource(UsageDataSourceResult... sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by on data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sumByDataSource(List<UsageDataSourceResult>)}.
         * 
         * @param sumByDataSource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByDataSource(java.util.Collection<UsageDataSourceResult>)
         */
        Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder>... sumByDataSource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * 
         * @param sumByResource
         *        The usage statistic sum organized by resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByResource(Collection<UsageResourceResult> sumByResource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * 
         * @param sumByResource
         *        The usage statistic sum organized by resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByResource(UsageResourceResult... sumByResource);

        /**
         * <p>
         * The usage statistic sum organized by resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sumByResource(List<UsageResourceResult>)}.
         * 
         * @param sumByResource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByResource(java.util.Collection<UsageResourceResult>)
         */
        Builder sumByResource(Consumer<UsageResourceResult.Builder>... sumByResource);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * 
         * @param topResources
         *        Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         *        expensive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topResources(Collection<UsageResourceResult> topResources);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * 
         * @param topResources
         *        Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         *        expensive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topResources(UsageResourceResult... topResources);

        /**
         * <p>
         * Lists the top 50 resources that have generated the most GuardDuty usage, in order from most to least
         * expensive.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder#build()} is called
         * immediately and its result is passed to {@link #topResources(List<UsageResourceResult>)}.
         * 
         * @param topResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageResourceResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topResources(java.util.Collection<UsageResourceResult>)
         */
        Builder topResources(Consumer<UsageResourceResult.Builder>... topResources);

        /**
         * <p>
         * The usage statistic sum organized by feature.
         * </p>
         * 
         * @param sumByFeature
         *        The usage statistic sum organized by feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByFeature(Collection<UsageFeatureResult> sumByFeature);

        /**
         * <p>
         * The usage statistic sum organized by feature.
         * </p>
         * 
         * @param sumByFeature
         *        The usage statistic sum organized by feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumByFeature(UsageFeatureResult... sumByFeature);

        /**
         * <p>
         * The usage statistic sum organized by feature.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.UsageFeatureResult.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.guardduty.model.UsageFeatureResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.UsageFeatureResult.Builder#build()} is called
         * immediately and its result is passed to {@link #sumByFeature(List<UsageFeatureResult>)}.
         * 
         * @param sumByFeature
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.UsageFeatureResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sumByFeature(java.util.Collection<UsageFeatureResult>)
         */
        Builder sumByFeature(Consumer<UsageFeatureResult.Builder>... sumByFeature);
    }

    static final class BuilderImpl implements Builder {
        private List<UsageAccountResult> sumByAccount = DefaultSdkAutoConstructList.getInstance();

        private List<UsageTopAccountsResult> topAccountsByFeature = DefaultSdkAutoConstructList.getInstance();

        private List<UsageDataSourceResult> sumByDataSource = DefaultSdkAutoConstructList.getInstance();

        private List<UsageResourceResult> sumByResource = DefaultSdkAutoConstructList.getInstance();

        private List<UsageResourceResult> topResources = DefaultSdkAutoConstructList.getInstance();

        private List<UsageFeatureResult> sumByFeature = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageStatistics model) {
            sumByAccount(model.sumByAccount);
            topAccountsByFeature(model.topAccountsByFeature);
            sumByDataSource(model.sumByDataSource);
            sumByResource(model.sumByResource);
            topResources(model.topResources);
            sumByFeature(model.sumByFeature);
        }

        public final List<UsageAccountResult.Builder> getSumByAccount() {
            List<UsageAccountResult.Builder> result = UsageAccountResultListCopier.copyToBuilder(this.sumByAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByAccount(Collection<UsageAccountResult.BuilderImpl> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copyFromBuilder(sumByAccount);
        }

        @Override
        public final Builder sumByAccount(Collection<UsageAccountResult> sumByAccount) {
            this.sumByAccount = UsageAccountResultListCopier.copy(sumByAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(UsageAccountResult... sumByAccount) {
            sumByAccount(Arrays.asList(sumByAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByAccount(Consumer<UsageAccountResult.Builder>... sumByAccount) {
            sumByAccount(Stream.of(sumByAccount).map(c -> UsageAccountResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageTopAccountsResult.Builder> getTopAccountsByFeature() {
            List<UsageTopAccountsResult.Builder> result = UsageTopAccountsResultListCopier
                    .copyToBuilder(this.topAccountsByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopAccountsByFeature(Collection<UsageTopAccountsResult.BuilderImpl> topAccountsByFeature) {
            this.topAccountsByFeature = UsageTopAccountsResultListCopier.copyFromBuilder(topAccountsByFeature);
        }

        @Override
        public final Builder topAccountsByFeature(Collection<UsageTopAccountsResult> topAccountsByFeature) {
            this.topAccountsByFeature = UsageTopAccountsResultListCopier.copy(topAccountsByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccountsByFeature(UsageTopAccountsResult... topAccountsByFeature) {
            topAccountsByFeature(Arrays.asList(topAccountsByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topAccountsByFeature(Consumer<UsageTopAccountsResult.Builder>... topAccountsByFeature) {
            topAccountsByFeature(Stream.of(topAccountsByFeature)
                    .map(c -> UsageTopAccountsResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UsageDataSourceResult.Builder> getSumByDataSource() {
            List<UsageDataSourceResult.Builder> result = UsageDataSourceResultListCopier.copyToBuilder(this.sumByDataSource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByDataSource(Collection<UsageDataSourceResult.BuilderImpl> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copyFromBuilder(sumByDataSource);
        }

        @Override
        public final Builder sumByDataSource(Collection<UsageDataSourceResult> sumByDataSource) {
            this.sumByDataSource = UsageDataSourceResultListCopier.copy(sumByDataSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(UsageDataSourceResult... sumByDataSource) {
            sumByDataSource(Arrays.asList(sumByDataSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByDataSource(Consumer<UsageDataSourceResult.Builder>... sumByDataSource) {
            sumByDataSource(Stream.of(sumByDataSource).map(c -> UsageDataSourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageResourceResult.Builder> getSumByResource() {
            List<UsageResourceResult.Builder> result = UsageResourceResultListCopier.copyToBuilder(this.sumByResource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByResource(Collection<UsageResourceResult.BuilderImpl> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copyFromBuilder(sumByResource);
        }

        @Override
        public final Builder sumByResource(Collection<UsageResourceResult> sumByResource) {
            this.sumByResource = UsageResourceResultListCopier.copy(sumByResource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(UsageResourceResult... sumByResource) {
            sumByResource(Arrays.asList(sumByResource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByResource(Consumer<UsageResourceResult.Builder>... sumByResource) {
            sumByResource(Stream.of(sumByResource).map(c -> UsageResourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageResourceResult.Builder> getTopResources() {
            List<UsageResourceResult.Builder> result = UsageResourceResultListCopier.copyToBuilder(this.topResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopResources(Collection<UsageResourceResult.BuilderImpl> topResources) {
            this.topResources = UsageResourceResultListCopier.copyFromBuilder(topResources);
        }

        @Override
        public final Builder topResources(Collection<UsageResourceResult> topResources) {
            this.topResources = UsageResourceResultListCopier.copy(topResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(UsageResourceResult... topResources) {
            topResources(Arrays.asList(topResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topResources(Consumer<UsageResourceResult.Builder>... topResources) {
            topResources(Stream.of(topResources).map(c -> UsageResourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UsageFeatureResult.Builder> getSumByFeature() {
            List<UsageFeatureResult.Builder> result = UsageFeatureResultListCopier.copyToBuilder(this.sumByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSumByFeature(Collection<UsageFeatureResult.BuilderImpl> sumByFeature) {
            this.sumByFeature = UsageFeatureResultListCopier.copyFromBuilder(sumByFeature);
        }

        @Override
        public final Builder sumByFeature(Collection<UsageFeatureResult> sumByFeature) {
            this.sumByFeature = UsageFeatureResultListCopier.copy(sumByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByFeature(UsageFeatureResult... sumByFeature) {
            sumByFeature(Arrays.asList(sumByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sumByFeature(Consumer<UsageFeatureResult.Builder>... sumByFeature) {
            sumByFeature(Stream.of(sumByFeature).map(c -> UsageFeatureResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageStatistics build() {
            return new UsageStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
