/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about whether the tags will be added to the S3 object after scanning.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalwareProtectionPlanActions implements SdkPojo, Serializable,
        ToCopyableBuilder<MalwareProtectionPlanActions.Builder, MalwareProtectionPlanActions> {
    private static final SdkField<MalwareProtectionPlanTaggingAction> TAGGING_FIELD = SdkField
            .<MalwareProtectionPlanTaggingAction> builder(MarshallingType.SDK_POJO).memberName("Tagging")
            .getter(getter(MalwareProtectionPlanActions::tagging)).setter(setter(Builder::tagging))
            .constructor(MalwareProtectionPlanTaggingAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final MalwareProtectionPlanTaggingAction tagging;

    private MalwareProtectionPlanActions(BuilderImpl builder) {
        this.tagging = builder.tagging;
    }

    /**
     * <p>
     * Indicates whether the scanned S3 object will have tags about the scan result.
     * </p>
     * 
     * @return Indicates whether the scanned S3 object will have tags about the scan result.
     */
    public final MalwareProtectionPlanTaggingAction tagging() {
        return tagging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareProtectionPlanActions)) {
            return false;
        }
        MalwareProtectionPlanActions other = (MalwareProtectionPlanActions) obj;
        return Objects.equals(tagging(), other.tagging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalwareProtectionPlanActions").add("Tagging", tagging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tagging":
            return Optional.ofNullable(clazz.cast(tagging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MalwareProtectionPlanActions, T> g) {
        return obj -> g.apply((MalwareProtectionPlanActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalwareProtectionPlanActions> {
        /**
         * <p>
         * Indicates whether the scanned S3 object will have tags about the scan result.
         * </p>
         * 
         * @param tagging
         *        Indicates whether the scanned S3 object will have tags about the scan result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagging(MalwareProtectionPlanTaggingAction tagging);

        /**
         * <p>
         * Indicates whether the scanned S3 object will have tags about the scan result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MalwareProtectionPlanTaggingAction.Builder} avoiding the need to create one manually via
         * {@link MalwareProtectionPlanTaggingAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionPlanTaggingAction.Builder#build()} is called
         * immediately and its result is passed to {@link #tagging(MalwareProtectionPlanTaggingAction)}.
         * 
         * @param tagging
         *        a consumer that will call methods on {@link MalwareProtectionPlanTaggingAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagging(MalwareProtectionPlanTaggingAction)
         */
        default Builder tagging(Consumer<MalwareProtectionPlanTaggingAction.Builder> tagging) {
            return tagging(MalwareProtectionPlanTaggingAction.builder().applyMutation(tagging).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MalwareProtectionPlanTaggingAction tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareProtectionPlanActions model) {
            tagging(model.tagging);
        }

        public final MalwareProtectionPlanTaggingAction.Builder getTagging() {
            return tagging != null ? tagging.toBuilder() : null;
        }

        public final void setTagging(MalwareProtectionPlanTaggingAction.BuilderImpl tagging) {
            this.tagging = tagging != null ? tagging.build() : null;
        }

        @Override
        public final Builder tagging(MalwareProtectionPlanTaggingAction tagging) {
            this.tagging = tagging;
            return this;
        }

        @Override
        public MalwareProtectionPlanActions build() {
            return new MalwareProtectionPlanActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
