/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMalwareProtectionPlansResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListMalwareProtectionPlansResponse.Builder, ListMalwareProtectionPlansResponse> {
    private static final SdkField<List<MalwareProtectionPlanSummary>> MALWARE_PROTECTION_PLANS_FIELD = SdkField
            .<List<MalwareProtectionPlanSummary>> builder(MarshallingType.LIST)
            .memberName("MalwareProtectionPlans")
            .getter(getter(ListMalwareProtectionPlansResponse::malwareProtectionPlans))
            .setter(setter(Builder::malwareProtectionPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtectionPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MalwareProtectionPlanSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MalwareProtectionPlanSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMalwareProtectionPlansResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MALWARE_PROTECTION_PLANS_FIELD, NEXT_TOKEN_FIELD));

    private final List<MalwareProtectionPlanSummary> malwareProtectionPlans;

    private final String nextToken;

    private ListMalwareProtectionPlansResponse(BuilderImpl builder) {
        super(builder);
        this.malwareProtectionPlans = builder.malwareProtectionPlans;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MalwareProtectionPlans property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMalwareProtectionPlans() {
        return malwareProtectionPlans != null && !(malwareProtectionPlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMalwareProtectionPlans} method.
     * </p>
     * 
     * @return A list of unique identifiers associated with each Malware Protection plan.
     */
    public final List<MalwareProtectionPlanSummary> malwareProtectionPlans() {
        return malwareProtectionPlans;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the list action. For subsequent calls to the action, fill nextToken in the request with the value
     *         of <code>NextToken</code> from the previous response to continue listing data.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMalwareProtectionPlans() ? malwareProtectionPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMalwareProtectionPlansResponse)) {
            return false;
        }
        ListMalwareProtectionPlansResponse other = (ListMalwareProtectionPlansResponse) obj;
        return hasMalwareProtectionPlans() == other.hasMalwareProtectionPlans()
                && Objects.equals(malwareProtectionPlans(), other.malwareProtectionPlans())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMalwareProtectionPlansResponse")
                .add("MalwareProtectionPlans", hasMalwareProtectionPlans() ? malwareProtectionPlans() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MalwareProtectionPlans":
            return Optional.ofNullable(clazz.cast(malwareProtectionPlans()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMalwareProtectionPlansResponse, T> g) {
        return obj -> g.apply((ListMalwareProtectionPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMalwareProtectionPlansResponse> {
        /**
         * <p>
         * A list of unique identifiers associated with each Malware Protection plan.
         * </p>
         * 
         * @param malwareProtectionPlans
         *        A list of unique identifiers associated with each Malware Protection plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtectionPlans(Collection<MalwareProtectionPlanSummary> malwareProtectionPlans);

        /**
         * <p>
         * A list of unique identifiers associated with each Malware Protection plan.
         * </p>
         * 
         * @param malwareProtectionPlans
         *        A list of unique identifiers associated with each Malware Protection plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtectionPlans(MalwareProtectionPlanSummary... malwareProtectionPlans);

        /**
         * <p>
         * A list of unique identifiers associated with each Malware Protection plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #malwareProtectionPlans(List<MalwareProtectionPlanSummary>)}.
         * 
         * @param malwareProtectionPlans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareProtectionPlans(java.util.Collection<MalwareProtectionPlanSummary>)
         */
        Builder malwareProtectionPlans(Consumer<MalwareProtectionPlanSummary.Builder>... malwareProtectionPlans);

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of
         * <code>NextToken</code> from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the list action. For subsequent calls to the action, fill nextToken in the request with
         *        the value of <code>NextToken</code> from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<MalwareProtectionPlanSummary> malwareProtectionPlans = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMalwareProtectionPlansResponse model) {
            super(model);
            malwareProtectionPlans(model.malwareProtectionPlans);
            nextToken(model.nextToken);
        }

        public final List<MalwareProtectionPlanSummary.Builder> getMalwareProtectionPlans() {
            List<MalwareProtectionPlanSummary.Builder> result = MalwareProtectionPlansSummaryCopier
                    .copyToBuilder(this.malwareProtectionPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMalwareProtectionPlans(Collection<MalwareProtectionPlanSummary.BuilderImpl> malwareProtectionPlans) {
            this.malwareProtectionPlans = MalwareProtectionPlansSummaryCopier.copyFromBuilder(malwareProtectionPlans);
        }

        @Override
        public final Builder malwareProtectionPlans(Collection<MalwareProtectionPlanSummary> malwareProtectionPlans) {
            this.malwareProtectionPlans = MalwareProtectionPlansSummaryCopier.copy(malwareProtectionPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareProtectionPlans(MalwareProtectionPlanSummary... malwareProtectionPlans) {
            malwareProtectionPlans(Arrays.asList(malwareProtectionPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareProtectionPlans(Consumer<MalwareProtectionPlanSummary.Builder>... malwareProtectionPlans) {
            malwareProtectionPlans(Stream.of(malwareProtectionPlans)
                    .map(c -> MalwareProtectionPlanSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMalwareProtectionPlansResponse build() {
            return new ListMalwareProtectionPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
