/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Kubernetes API for which you check if you have permission to call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesPermissionCheckedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesPermissionCheckedDetails.Builder, KubernetesPermissionCheckedDetails> {
    private static final SdkField<String> VERB_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Verb")
            .getter(getter(KubernetesPermissionCheckedDetails::verb)).setter(setter(Builder::verb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(KubernetesPermissionCheckedDetails::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(KubernetesPermissionCheckedDetails::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<Boolean> ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Allowed").getter(getter(KubernetesPermissionCheckedDetails::allowed)).setter(setter(Builder::allowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERB_FIELD, RESOURCE_FIELD,
            NAMESPACE_FIELD, ALLOWED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String verb;

    private final String resource;

    private final String namespace;

    private final Boolean allowed;

    private KubernetesPermissionCheckedDetails(BuilderImpl builder) {
        this.verb = builder.verb;
        this.resource = builder.resource;
        this.namespace = builder.namespace;
        this.allowed = builder.allowed;
    }

    /**
     * <p>
     * The verb component of the Kubernetes API call. For example, when you check whether or not you have the permission
     * to call the <code>CreatePod</code> API, the verb component will be <code>Create</code>.
     * </p>
     * 
     * @return The verb component of the Kubernetes API call. For example, when you check whether or not you have the
     *         permission to call the <code>CreatePod</code> API, the verb component will be <code>Create</code>.
     */
    public final String verb() {
        return verb;
    }

    /**
     * <p>
     * The Kubernetes resource with which your Kubernetes API call will interact.
     * </p>
     * 
     * @return The Kubernetes resource with which your Kubernetes API call will interact.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The namespace where the Kubernetes API action will take place.
     * </p>
     * 
     * @return The namespace where the Kubernetes API action will take place.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * Information whether the user has the permission to call the Kubernetes API.
     * </p>
     * 
     * @return Information whether the user has the permission to call the Kubernetes API.
     */
    public final Boolean allowed() {
        return allowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verb());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(allowed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesPermissionCheckedDetails)) {
            return false;
        }
        KubernetesPermissionCheckedDetails other = (KubernetesPermissionCheckedDetails) obj;
        return Objects.equals(verb(), other.verb()) && Objects.equals(resource(), other.resource())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(allowed(), other.allowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesPermissionCheckedDetails").add("Verb", verb()).add("Resource", resource())
                .add("Namespace", namespace()).add("Allowed", allowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Verb":
            return Optional.ofNullable(clazz.cast(verb()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Allowed":
            return Optional.ofNullable(clazz.cast(allowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesPermissionCheckedDetails, T> g) {
        return obj -> g.apply((KubernetesPermissionCheckedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesPermissionCheckedDetails> {
        /**
         * <p>
         * The verb component of the Kubernetes API call. For example, when you check whether or not you have the
         * permission to call the <code>CreatePod</code> API, the verb component will be <code>Create</code>.
         * </p>
         * 
         * @param verb
         *        The verb component of the Kubernetes API call. For example, when you check whether or not you have the
         *        permission to call the <code>CreatePod</code> API, the verb component will be <code>Create</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verb(String verb);

        /**
         * <p>
         * The Kubernetes resource with which your Kubernetes API call will interact.
         * </p>
         * 
         * @param resource
         *        The Kubernetes resource with which your Kubernetes API call will interact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The namespace where the Kubernetes API action will take place.
         * </p>
         * 
         * @param namespace
         *        The namespace where the Kubernetes API action will take place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * Information whether the user has the permission to call the Kubernetes API.
         * </p>
         * 
         * @param allowed
         *        Information whether the user has the permission to call the Kubernetes API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowed(Boolean allowed);
    }

    static final class BuilderImpl implements Builder {
        private String verb;

        private String resource;

        private String namespace;

        private Boolean allowed;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesPermissionCheckedDetails model) {
            verb(model.verb);
            resource(model.resource);
            namespace(model.namespace);
            allowed(model.allowed);
        }

        public final String getVerb() {
            return verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Boolean getAllowed() {
            return allowed;
        }

        public final void setAllowed(Boolean allowed) {
            this.allowed = allowed;
        }

        @Override
        public final Builder allowed(Boolean allowed) {
            this.allowed = allowed;
            return this;
        }

        @Override
        public KubernetesPermissionCheckedDetails build() {
            return new KubernetesPermissionCheckedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
