/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon EC2 instance that is running the Amazon ECS container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerInstanceDetails.Builder, ContainerInstanceDetails> {
    private static final SdkField<Long> COVERED_CONTAINER_INSTANCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CoveredContainerInstances").getter(getter(ContainerInstanceDetails::coveredContainerInstances))
            .setter(setter(Builder::coveredContainerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coveredContainerInstances").build())
            .build();

    private static final SdkField<Long> COMPATIBLE_CONTAINER_INSTANCES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CompatibleContainerInstances")
            .getter(getter(ContainerInstanceDetails::compatibleContainerInstances))
            .setter(setter(Builder::compatibleContainerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleContainerInstances")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COVERED_CONTAINER_INSTANCES_FIELD, COMPATIBLE_CONTAINER_INSTANCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long coveredContainerInstances;

    private final Long compatibleContainerInstances;

    private ContainerInstanceDetails(BuilderImpl builder) {
        this.coveredContainerInstances = builder.coveredContainerInstances;
        this.compatibleContainerInstances = builder.compatibleContainerInstances;
    }

    /**
     * <p>
     * Represents the nodes in the Amazon ECS cluster that has a <code>HEALTHY</code> coverage status.
     * </p>
     * 
     * @return Represents the nodes in the Amazon ECS cluster that has a <code>HEALTHY</code> coverage status.
     */
    public final Long coveredContainerInstances() {
        return coveredContainerInstances;
    }

    /**
     * <p>
     * Represents total number of nodes in the Amazon ECS cluster.
     * </p>
     * 
     * @return Represents total number of nodes in the Amazon ECS cluster.
     */
    public final Long compatibleContainerInstances() {
        return compatibleContainerInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coveredContainerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(compatibleContainerInstances());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstanceDetails)) {
            return false;
        }
        ContainerInstanceDetails other = (ContainerInstanceDetails) obj;
        return Objects.equals(coveredContainerInstances(), other.coveredContainerInstances())
                && Objects.equals(compatibleContainerInstances(), other.compatibleContainerInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerInstanceDetails").add("CoveredContainerInstances", coveredContainerInstances())
                .add("CompatibleContainerInstances", compatibleContainerInstances()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoveredContainerInstances":
            return Optional.ofNullable(clazz.cast(coveredContainerInstances()));
        case "CompatibleContainerInstances":
            return Optional.ofNullable(clazz.cast(compatibleContainerInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInstanceDetails, T> g) {
        return obj -> g.apply((ContainerInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerInstanceDetails> {
        /**
         * <p>
         * Represents the nodes in the Amazon ECS cluster that has a <code>HEALTHY</code> coverage status.
         * </p>
         * 
         * @param coveredContainerInstances
         *        Represents the nodes in the Amazon ECS cluster that has a <code>HEALTHY</code> coverage status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coveredContainerInstances(Long coveredContainerInstances);

        /**
         * <p>
         * Represents total number of nodes in the Amazon ECS cluster.
         * </p>
         * 
         * @param compatibleContainerInstances
         *        Represents total number of nodes in the Amazon ECS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleContainerInstances(Long compatibleContainerInstances);
    }

    static final class BuilderImpl implements Builder {
        private Long coveredContainerInstances;

        private Long compatibleContainerInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInstanceDetails model) {
            coveredContainerInstances(model.coveredContainerInstances);
            compatibleContainerInstances(model.compatibleContainerInstances);
        }

        public final Long getCoveredContainerInstances() {
            return coveredContainerInstances;
        }

        public final void setCoveredContainerInstances(Long coveredContainerInstances) {
            this.coveredContainerInstances = coveredContainerInstances;
        }

        @Override
        public final Builder coveredContainerInstances(Long coveredContainerInstances) {
            this.coveredContainerInstances = coveredContainerInstances;
            return this;
        }

        public final Long getCompatibleContainerInstances() {
            return compatibleContainerInstances;
        }

        public final void setCompatibleContainerInstances(Long compatibleContainerInstances) {
            this.compatibleContainerInstances = compatibleContainerInstances;
        }

        @Override
        public final Builder compatibleContainerInstances(Long compatibleContainerInstances) {
            this.compatibleContainerInstances = compatibleContainerInstances;
            return this;
        }

        @Override
        public ContainerInstanceDetails build() {
            return new ContainerInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
