/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class BehaviorCopier {
    static Map<String, Map<String, AnomalyObject>> copy(Map<String, ? extends Map<String, ? extends AnomalyObject>> behaviorParam) {
        Map<String, Map<String, AnomalyObject>> map;
        if (behaviorParam == null || behaviorParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, AnomalyObject>> modifiableMap = new LinkedHashMap<>();
            behaviorParam.forEach((key, value) -> {
                Map<String, AnomalyObject> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AnomalyObject> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, AnomalyObject>> copyFromBuilder(
            Map<String, ? extends Map<String, ? extends AnomalyObject.Builder>> behaviorParam) {
        Map<String, Map<String, AnomalyObject>> map;
        if (behaviorParam == null || behaviorParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, AnomalyObject>> modifiableMap = new LinkedHashMap<>();
            behaviorParam.forEach((key, value) -> {
                Map<String, AnomalyObject> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AnomalyObject> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        AnomalyObject member = value1 == null ? null : value1.build();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, AnomalyObject.Builder>> copyToBuilder(
            Map<String, ? extends Map<String, ? extends AnomalyObject>> behaviorParam) {
        Map<String, Map<String, AnomalyObject.Builder>> map;
        if (behaviorParam == null || behaviorParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, AnomalyObject.Builder>> modifiableMap = new LinkedHashMap<>();
            behaviorParam.forEach((key, value) -> {
                Map<String, AnomalyObject.Builder> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AnomalyObject.Builder> modifiableMap1 = new LinkedHashMap<>();
                    value.forEach((key1, value1) -> {
                        AnomalyObject.Builder member = value1 == null ? null : value1.toBuilder();
                        modifiableMap1.put(key1, member);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
