/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a JSON classifier for <code>CreateClassifier</code> to create.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJsonClassifierRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateJsonClassifierRequest.Builder, CreateJsonClassifierRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateJsonClassifierRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JsonPath").getter(getter(CreateJsonClassifierRequest::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, JSON_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String jsonPath;

    private CreateJsonClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.jsonPath = builder.jsonPath;
    }

    /**
     * <p>
     * The name of the classifier.
     * </p>
     * 
     * @return The name of the classifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A <code>JsonPath</code> string defining the JSON data for the classifier to classify. Glue supports a subset of
     * JsonPath, as described in <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath
     * Custom Classifiers</a>.
     * </p>
     * 
     * @return A <code>JsonPath</code> string defining the JSON data for the classifier to classify. Glue supports a
     *         subset of JsonPath, as described in <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing
     *         JsonPath Custom Classifiers</a>.
     */
    public final String jsonPath() {
        return jsonPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJsonClassifierRequest)) {
            return false;
        }
        CreateJsonClassifierRequest other = (CreateJsonClassifierRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(jsonPath(), other.jsonPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJsonClassifierRequest").add("Name", name()).add("JsonPath", jsonPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "JsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJsonClassifierRequest, T> g) {
        return obj -> g.apply((CreateJsonClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateJsonClassifierRequest> {
        /**
         * <p>
         * The name of the classifier.
         * </p>
         * 
         * @param name
         *        The name of the classifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <code>JsonPath</code> string defining the JSON data for the classifier to classify. Glue supports a subset
         * of JsonPath, as described in <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing
         * JsonPath Custom Classifiers</a>.
         * </p>
         * 
         * @param jsonPath
         *        A <code>JsonPath</code> string defining the JSON data for the classifier to classify. Glue supports a
         *        subset of JsonPath, as described in <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json"
         *        >Writing JsonPath Custom Classifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String jsonPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJsonClassifierRequest model) {
            name(model.name);
            jsonPath(model.jsonPath);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        @Override
        public CreateJsonClassifierRequest build() {
            return new CreateJsonClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
