/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisionedCapacityResponse extends GlacierResponse implements
        ToCopyableBuilder<ListProvisionedCapacityResponse.Builder, ListProvisionedCapacityResponse> {
    private static final SdkField<List<ProvisionedCapacityDescription>> PROVISIONED_CAPACITY_LIST_FIELD = SdkField
            .<List<ProvisionedCapacityDescription>> builder(MarshallingType.LIST)
            .memberName("ProvisionedCapacityList")
            .getter(getter(ListProvisionedCapacityResponse::provisionedCapacityList))
            .setter(setter(Builder::provisionedCapacityList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacityList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisionedCapacityDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisionedCapacityDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROVISIONED_CAPACITY_LIST_FIELD));

    private final List<ProvisionedCapacityDescription> provisionedCapacityList;

    private ListProvisionedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedCapacityList = builder.provisionedCapacityList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedCapacityList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisionedCapacityList() {
        return provisionedCapacityList != null && !(provisionedCapacityList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response body contains the following JSON fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedCapacityList} method.
     * </p>
     * 
     * @return The response body contains the following JSON fields.
     */
    public final List<ProvisionedCapacityDescription> provisionedCapacityList() {
        return provisionedCapacityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedCapacityList() ? provisionedCapacityList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedCapacityResponse)) {
            return false;
        }
        ListProvisionedCapacityResponse other = (ListProvisionedCapacityResponse) obj;
        return hasProvisionedCapacityList() == other.hasProvisionedCapacityList()
                && Objects.equals(provisionedCapacityList(), other.provisionedCapacityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProvisionedCapacityResponse")
                .add("ProvisionedCapacityList", hasProvisionedCapacityList() ? provisionedCapacityList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedCapacityList":
            return Optional.ofNullable(clazz.cast(provisionedCapacityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedCapacityResponse, T> g) {
        return obj -> g.apply((ListProvisionedCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProvisionedCapacityResponse> {
        /**
         * <p>
         * The response body contains the following JSON fields.
         * </p>
         * 
         * @param provisionedCapacityList
         *        The response body contains the following JSON fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> provisionedCapacityList);

        /**
         * <p>
         * The response body contains the following JSON fields.
         * </p>
         * 
         * @param provisionedCapacityList
         *        The response body contains the following JSON fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacityList(ProvisionedCapacityDescription... provisionedCapacityList);

        /**
         * <p>
         * The response body contains the following JSON fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #provisionedCapacityList(List<ProvisionedCapacityDescription>)}.
         * 
         * @param provisionedCapacityList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedCapacityList(java.util.Collection<ProvisionedCapacityDescription>)
         */
        Builder provisionedCapacityList(Consumer<ProvisionedCapacityDescription.Builder>... provisionedCapacityList);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private List<ProvisionedCapacityDescription> provisionedCapacityList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedCapacityResponse model) {
            super(model);
            provisionedCapacityList(model.provisionedCapacityList);
        }

        public final List<ProvisionedCapacityDescription.Builder> getProvisionedCapacityList() {
            List<ProvisionedCapacityDescription.Builder> result = ProvisionedCapacityListCopier
                    .copyToBuilder(this.provisionedCapacityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedCapacityList(
                Collection<ProvisionedCapacityDescription.BuilderImpl> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copyFromBuilder(provisionedCapacityList);
        }

        @Override
        public final Builder provisionedCapacityList(Collection<ProvisionedCapacityDescription> provisionedCapacityList) {
            this.provisionedCapacityList = ProvisionedCapacityListCopier.copy(provisionedCapacityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedCapacityList(ProvisionedCapacityDescription... provisionedCapacityList) {
            provisionedCapacityList(Arrays.asList(provisionedCapacityList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedCapacityList(Consumer<ProvisionedCapacityDescription.Builder>... provisionedCapacityList) {
            provisionedCapacityList(Stream.of(provisionedCapacityList)
                    .map(c -> ProvisionedCapacityDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProvisionedCapacityResponse build() {
            return new ListProvisionedCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
