/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration;

public class DescribeMatchmakingConfigurationsIterable
implements SdkIterable<DescribeMatchmakingConfigurationsResponse> {
    private final GameLiftClient client;
    private final DescribeMatchmakingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMatchmakingConfigurationsIterable(GameLiftClient client, DescribeMatchmakingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMatchmakingConfigurationsResponseFetcher();
    }

    public Iterator<DescribeMatchmakingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MatchmakingConfiguration> configurations() {
        Function<DescribeMatchmakingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurations() != null) {
                return response.configurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMatchmakingConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeMatchmakingConfigurationsResponse> {
        private DescribeMatchmakingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMatchmakingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMatchmakingConfigurationsResponse nextPage(DescribeMatchmakingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMatchmakingConfigurationsIterable.this.client.describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsIterable.this.firstRequest);
            }
            return DescribeMatchmakingConfigurationsIterable.this.client.describeMatchmakingConfigurations((DescribeMatchmakingConfigurationsRequest)((Object)DescribeMatchmakingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

