/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.LocationState;
import software.amazon.awssdk.services.gamelift.model.LocationStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetLocationsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, CreateFleetLocationsResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(CreateFleetLocationsResponse.getter(CreateFleetLocationsResponse::fleetId)).setter(CreateFleetLocationsResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(CreateFleetLocationsResponse.getter(CreateFleetLocationsResponse::fleetArn)).setter(CreateFleetLocationsResponse.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocationStates").getter(CreateFleetLocationsResponse.getter(CreateFleetLocationsResponse::locationStates)).setter(CreateFleetLocationsResponse.setter(Builder::locationStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, LOCATION_STATES_FIELD));
    private final String fleetId;
    private final String fleetArn;
    private final List<LocationState> locationStates;

    private CreateFleetLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.locationStates = builder.locationStates;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final boolean hasLocationStates() {
        return this.locationStates != null && !(this.locationStates instanceof SdkAutoConstructList);
    }

    public final List<LocationState> locationStates() {
        return this.locationStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationStates() ? this.locationStates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetLocationsResponse)) {
            return false;
        }
        CreateFleetLocationsResponse other = (CreateFleetLocationsResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && this.hasLocationStates() == other.hasLocationStates() && Objects.equals(this.locationStates(), other.locationStates());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetLocationsResponse").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("LocationStates", this.hasLocationStates() ? this.locationStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "LocationStates": {
                return Optional.ofNullable(clazz.cast(this.locationStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetLocationsResponse, T> g) {
        return obj -> g.apply((CreateFleetLocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetLocationsResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.locationStates(model.locationStates);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStateListCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStateListCopier.copyFromBuilder(locationStates);
        }

        @Override
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStateListCopier.copy(locationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(LocationState ... locationStates) {
            this.locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder> ... locationStates) {
            this.locationStates(Stream.of(locationStates).map(c -> (LocationState)((LocationState.Builder)LocationState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetLocationsResponse build() {
            return new CreateFleetLocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetLocationsResponse> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder locationStates(Collection<LocationState> var1);

        public Builder locationStates(LocationState ... var1);

        public Builder locationStates(Consumer<LocationState.Builder> ... var1);
    }
}

