/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.IpProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerPortMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerPortMapping> {
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ContainerPort").getter(ContainerPortMapping.getter(ContainerPortMapping::containerPort)).setter(ContainerPortMapping.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPort").build()}).build();
    private static final SdkField<Integer> CONNECTION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionPort").getter(ContainerPortMapping.getter(ContainerPortMapping::connectionPort)).setter(ContainerPortMapping.setter(Builder::connectionPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(ContainerPortMapping.getter(ContainerPortMapping::protocolAsString)).setter(ContainerPortMapping.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PORT_FIELD, CONNECTION_PORT_FIELD, PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer containerPort;
    private final Integer connectionPort;
    private final String protocol;

    private ContainerPortMapping(BuilderImpl builder) {
        this.containerPort = builder.containerPort;
        this.connectionPort = builder.connectionPort;
        this.protocol = builder.protocol;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public final Integer connectionPort() {
        return this.connectionPort;
    }

    public final IpProtocol protocol() {
        return IpProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerPortMapping)) {
            return false;
        }
        ContainerPortMapping other = (ContainerPortMapping)obj;
        return Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.connectionPort(), other.connectionPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerPortMapping").add("ContainerPort", (Object)(this.containerPort() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectionPort", (Object)(this.connectionPort() == null ? null : "*** Sensitive Data Redacted ***")).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "ConnectionPort": {
                return Optional.ofNullable(clazz.cast(this.connectionPort()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerPortMapping, T> g) {
        return obj -> g.apply((ContainerPortMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer containerPort;
        private Integer connectionPort;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerPortMapping model) {
            this.containerPort(model.containerPort);
            this.connectionPort(model.connectionPort);
            this.protocol(model.protocol);
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final Integer getConnectionPort() {
            return this.connectionPort;
        }

        public final void setConnectionPort(Integer connectionPort) {
            this.connectionPort = connectionPort;
        }

        @Override
        public final Builder connectionPort(Integer connectionPort) {
            this.connectionPort = connectionPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(IpProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public ContainerPortMapping build() {
            return new ContainerPortMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerPortMapping> {
        public Builder containerPort(Integer var1);

        public Builder connectionPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(IpProtocol var1);
    }
}

