/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMatchmakingConfigurationRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateMatchmakingConfigurationRequest.Builder, CreateMatchmakingConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateMatchmakingConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMatchmakingConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> GAME_SESSION_QUEUE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GameSessionQueueArns")
            .getter(getter(CreateMatchmakingConfigurationRequest::gameSessionQueueArns))
            .setter(setter(Builder::gameSessionQueueArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> REQUEST_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestTimeoutSeconds").getter(getter(CreateMatchmakingConfigurationRequest::requestTimeoutSeconds))
            .setter(setter(Builder::requestTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> ACCEPTANCE_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AcceptanceTimeoutSeconds")
            .getter(getter(CreateMatchmakingConfigurationRequest::acceptanceTimeoutSeconds))
            .setter(setter(Builder::acceptanceTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceTimeoutSeconds").build())
            .build();

    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AcceptanceRequired").getter(getter(CreateMatchmakingConfigurationRequest::acceptanceRequired))
            .setter(setter(Builder::acceptanceRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").build())
            .build();

    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(CreateMatchmakingConfigurationRequest::ruleSetName))
            .setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final SdkField<String> NOTIFICATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationTarget").getter(getter(CreateMatchmakingConfigurationRequest::notificationTarget))
            .setter(setter(Builder::notificationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTarget").build())
            .build();

    private static final SdkField<Integer> ADDITIONAL_PLAYER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdditionalPlayerCount").getter(getter(CreateMatchmakingConfigurationRequest::additionalPlayerCount))
            .setter(setter(Builder::additionalPlayerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalPlayerCount").build())
            .build();

    private static final SdkField<String> CUSTOM_EVENT_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomEventData").getter(getter(CreateMatchmakingConfigurationRequest::customEventData))
            .setter(setter(Builder::customEventData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEventData").build()).build();

    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField
            .<List<GameProperty>> builder(MarshallingType.LIST)
            .memberName("GameProperties")
            .getter(getter(CreateMatchmakingConfigurationRequest::gameProperties))
            .setter(setter(Builder::gameProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionData").getter(getter(CreateMatchmakingConfigurationRequest::gameSessionData))
            .setter(setter(Builder::gameSessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()).build();

    private static final SdkField<String> BACKFILL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackfillMode").getter(getter(CreateMatchmakingConfigurationRequest::backfillModeAsString))
            .setter(setter(Builder::backfillMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillMode").build()).build();

    private static final SdkField<String> FLEX_MATCH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlexMatchMode").getter(getter(CreateMatchmakingConfigurationRequest::flexMatchModeAsString))
            .setter(setter(Builder::flexMatchMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexMatchMode").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMatchmakingConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            GAME_SESSION_QUEUE_ARNS_FIELD, REQUEST_TIMEOUT_SECONDS_FIELD, ACCEPTANCE_TIMEOUT_SECONDS_FIELD,
            ACCEPTANCE_REQUIRED_FIELD, RULE_SET_NAME_FIELD, NOTIFICATION_TARGET_FIELD, ADDITIONAL_PLAYER_COUNT_FIELD,
            CUSTOM_EVENT_DATA_FIELD, GAME_PROPERTIES_FIELD, GAME_SESSION_DATA_FIELD, BACKFILL_MODE_FIELD, FLEX_MATCH_MODE_FIELD,
            TAGS_FIELD));

    private final String name;

    private final String description;

    private final List<String> gameSessionQueueArns;

    private final Integer requestTimeoutSeconds;

    private final Integer acceptanceTimeoutSeconds;

    private final Boolean acceptanceRequired;

    private final String ruleSetName;

    private final String notificationTarget;

    private final Integer additionalPlayerCount;

    private final String customEventData;

    private final List<GameProperty> gameProperties;

    private final String gameSessionData;

    private final String backfillMode;

    private final String flexMatchMode;

    private final List<Tag> tags;

    private CreateMatchmakingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.gameSessionQueueArns = builder.gameSessionQueueArns;
        this.requestTimeoutSeconds = builder.requestTimeoutSeconds;
        this.acceptanceTimeoutSeconds = builder.acceptanceTimeoutSeconds;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.ruleSetName = builder.ruleSetName;
        this.notificationTarget = builder.notificationTarget;
        this.additionalPlayerCount = builder.additionalPlayerCount;
        this.customEventData = builder.customEventData;
        this.gameProperties = builder.gameProperties;
        this.gameSessionData = builder.gameSessionData;
        this.backfillMode = builder.backfillMode;
        this.flexMatchMode = builder.flexMatchMode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for the matchmaking configuration. This name is used to identify the configuration associated
     * with a matchmaking request or ticket.
     * </p>
     * 
     * @return A unique identifier for the matchmaking configuration. This name is used to identify the configuration
     *         associated with a matchmaking request or ticket.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A human-readable description of the matchmaking configuration.
     * </p>
     * 
     * @return A human-readable description of the matchmaking configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the GameSessionQueueArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGameSessionQueueArns() {
        return gameSessionQueueArns != null && !(gameSessionQueueArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (<a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>)
     * that is assigned to a Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique
     * across all Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>.
     * Queues can be located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions for
     * matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to
     * <code>STANDALONE</code>, do not set this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGameSessionQueueArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (<a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
     *         Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique across all
     *         Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>.
     *         Queues can be located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions
     *         for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to
     *         <code>STANDALONE</code>, do not set this parameter.
     */
    public final List<String> gameSessionQueueArns() {
        return gameSessionQueueArns;
    }

    /**
     * <p>
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests
     * that fail due to timing out can be resubmitted as needed.
     * </p>
     * 
     * @return The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     *         Requests that fail due to timing out can be resubmitted as needed.
     */
    public final Integer requestTimeoutSeconds() {
        return requestTimeoutSeconds;
    }

    /**
     * <p>
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     * </p>
     * 
     * @return The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is
     *         required.
     */
    public final Integer acceptanceTimeoutSeconds() {
        return acceptanceTimeoutSeconds;
    }

    /**
     * <p>
     * A flag that determines whether a match that was created with this configuration must be accepted by the matched
     * players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking tickets use the
     * status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player
     * acceptance.
     * </p>
     * 
     * @return A flag that determines whether a match that was created with this configuration must be accepted by the
     *         matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking
     *         tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is
     *         waiting for player acceptance.
     */
    public final Boolean acceptanceRequired() {
        return acceptanceRequired;
    }

    /**
     * <p>
     * A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule set
     * name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
     * </p>
     * 
     * @return A unique identifier for the matchmaking rule set to use with this configuration. You can use either the
     *         rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the
     *         same Region.
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * An SNS topic ARN that is set up to receive matchmaking notifications. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up
     * notifications for matchmaking</a> for more information.
     * </p>
     * 
     * @return An SNS topic ARN that is set up to receive matchmaking notifications. See <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up
     *         notifications for matchmaking</a> for more information.
     */
    public final String notificationTarget() {
        return notificationTarget;
    }

    /**
     * <p>
     * The number of player slots in a match to keep open for future players. For example, if the configuration's rule
     * set specifies a match for a single 10-person team, and the additional player count is set to 2, 10 players will
     * be selected for the match and 2 more player slots will be open for future players. This parameter is not used if
     * <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
     * </p>
     * 
     * @return The number of player slots in a match to keep open for future players. For example, if the
     *         configuration's rule set specifies a match for a single 10-person team, and the additional player count
     *         is set to 2, 10 players will be selected for the match and 2 more player slots will be open for future
     *         players. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
     */
    public final Integer additionalPlayerCount() {
        return additionalPlayerCount;
    }

    /**
     * <p>
     * Information to be added to all events related to this matchmaking configuration.
     * </p>
     * 
     * @return Information to be added to all events related to this matchmaking configuration.
     */
    public final String customEventData() {
        return customEventData;
    }

    /**
     * For responses, this returns true if the service returned a value for the GameProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGameProperties() {
        return gameProperties != null && !(gameProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of key-value pairs that can store custom data in a game session. For example:
     * <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
     * <code>GameSession</code> object that is created for a successful match. This parameter is not used if
     * <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGameProperties} method.
     * </p>
     * 
     * @return A set of key-value pairs that can store custom data in a game session. For example:
     *         <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
     *         <code>GameSession</code> object that is created for a successful match. This parameter is not used if
     *         <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
     */
    public final List<GameProperty> gameProperties() {
        return gameProperties;
    }

    /**
     * <p>
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server
     * process with a request to start a new game session (see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is created
     * for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to
     * <code>STANDALONE</code>.
     * </p>
     * 
     * @return A set of custom game session properties, formatted as a single string value. This data is passed to a
     *         game server process with a request to start a new game session (see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is
     *         created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to
     *         <code>STANDALONE</code>.
     */
    public final String gameSessionData() {
        return gameSessionData;
    }

    /**
     * <p>
     * The method used to backfill game sessions that are created with this matchmaking configuration. Specify
     * <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature.
     * Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game session has one
     * or more open slots. Learn more about manual and automatic backfill in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games
     * with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
     * <code>STANDALONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillMode} will
     * return {@link BackfillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backfillModeAsString}.
     * </p>
     * 
     * @return The method used to backfill game sessions that are created with this matchmaking configuration. Specify
     *         <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill
     *         feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game
     *         session has one or more open slots. Learn more about manual and automatic backfill in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing
     *         Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
     *         <code>STANDALONE</code>.
     * @see BackfillMode
     */
    public final BackfillMode backfillMode() {
        return BackfillMode.fromValue(backfillMode);
    }

    /**
     * <p>
     * The method used to backfill game sessions that are created with this matchmaking configuration. Specify
     * <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature.
     * Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game session has one
     * or more open slots. Learn more about manual and automatic backfill in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing Games
     * with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
     * <code>STANDALONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backfillMode} will
     * return {@link BackfillMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backfillModeAsString}.
     * </p>
     * 
     * @return The method used to backfill game sessions that are created with this matchmaking configuration. Specify
     *         <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill
     *         feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game
     *         session has one or more open slots. Learn more about manual and automatic backfill in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing
     *         Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
     *         <code>STANDALONE</code>.
     * @see BackfillMode
     */
    public final String backfillModeAsString() {
        return backfillMode;
    }

    /**
     * <p>
     * Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a standalone
     * matchmaking solution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
     * assignments, in a <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
     * MatchmakingSucceeded</a> event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game session
     * for the match.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flexMatchMode}
     * will return {@link FlexMatchMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flexMatchModeAsString}.
     * </p>
     * 
     * @return Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
     *         standalone matchmaking solution. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
     *         assignments, in a <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
     *         > MatchmakingSucceeded</a> event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game
     *         session for the match.
     *         </p>
     *         </li>
     * @see FlexMatchMode
     */
    public final FlexMatchMode flexMatchMode() {
        return FlexMatchMode.fromValue(flexMatchMode);
    }

    /**
     * <p>
     * Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a standalone
     * matchmaking solution.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
     * assignments, in a <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">
     * MatchmakingSucceeded</a> event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game session
     * for the match.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flexMatchMode}
     * will return {@link FlexMatchMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flexMatchModeAsString}.
     * </p>
     * 
     * @return Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
     *         standalone matchmaking solution. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
     *         assignments, in a <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
     *         > MatchmakingSucceeded</a> event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game
     *         session for the match.
     *         </p>
     *         </li>
     * @see FlexMatchMode
     */
    public final String flexMatchModeAsString() {
        return flexMatchMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined key-value
     * pairs. Tagging Amazon Web Services resources are useful for resource management, access management and cost
     * allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     * Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
     *         key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
     *         management and cost allocation. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
     *         Resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasGameSessionQueueArns() ? gameSessionQueueArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(additionalPlayerCount());
        hashCode = 31 * hashCode + Objects.hashCode(customEventData());
        hashCode = 31 * hashCode + Objects.hashCode(hasGameProperties() ? gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(backfillModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flexMatchModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMatchmakingConfigurationRequest)) {
            return false;
        }
        CreateMatchmakingConfigurationRequest other = (CreateMatchmakingConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasGameSessionQueueArns() == other.hasGameSessionQueueArns()
                && Objects.equals(gameSessionQueueArns(), other.gameSessionQueueArns())
                && Objects.equals(requestTimeoutSeconds(), other.requestTimeoutSeconds())
                && Objects.equals(acceptanceTimeoutSeconds(), other.acceptanceTimeoutSeconds())
                && Objects.equals(acceptanceRequired(), other.acceptanceRequired())
                && Objects.equals(ruleSetName(), other.ruleSetName())
                && Objects.equals(notificationTarget(), other.notificationTarget())
                && Objects.equals(additionalPlayerCount(), other.additionalPlayerCount())
                && Objects.equals(customEventData(), other.customEventData()) && hasGameProperties() == other.hasGameProperties()
                && Objects.equals(gameProperties(), other.gameProperties())
                && Objects.equals(gameSessionData(), other.gameSessionData())
                && Objects.equals(backfillModeAsString(), other.backfillModeAsString())
                && Objects.equals(flexMatchModeAsString(), other.flexMatchModeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMatchmakingConfigurationRequest").add("Name", name()).add("Description", description())
                .add("GameSessionQueueArns", hasGameSessionQueueArns() ? gameSessionQueueArns() : null)
                .add("RequestTimeoutSeconds", requestTimeoutSeconds())
                .add("AcceptanceTimeoutSeconds", acceptanceTimeoutSeconds()).add("AcceptanceRequired", acceptanceRequired())
                .add("RuleSetName", ruleSetName()).add("NotificationTarget", notificationTarget())
                .add("AdditionalPlayerCount", additionalPlayerCount()).add("CustomEventData", customEventData())
                .add("GameProperties", hasGameProperties() ? gameProperties() : null).add("GameSessionData", gameSessionData())
                .add("BackfillMode", backfillModeAsString()).add("FlexMatchMode", flexMatchModeAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GameSessionQueueArns":
            return Optional.ofNullable(clazz.cast(gameSessionQueueArns()));
        case "RequestTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(requestTimeoutSeconds()));
        case "AcceptanceTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(acceptanceTimeoutSeconds()));
        case "AcceptanceRequired":
            return Optional.ofNullable(clazz.cast(acceptanceRequired()));
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "NotificationTarget":
            return Optional.ofNullable(clazz.cast(notificationTarget()));
        case "AdditionalPlayerCount":
            return Optional.ofNullable(clazz.cast(additionalPlayerCount()));
        case "CustomEventData":
            return Optional.ofNullable(clazz.cast(customEventData()));
        case "GameProperties":
            return Optional.ofNullable(clazz.cast(gameProperties()));
        case "GameSessionData":
            return Optional.ofNullable(clazz.cast(gameSessionData()));
        case "BackfillMode":
            return Optional.ofNullable(clazz.cast(backfillModeAsString()));
        case "FlexMatchMode":
            return Optional.ofNullable(clazz.cast(flexMatchModeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMatchmakingConfigurationRequest, T> g) {
        return obj -> g.apply((CreateMatchmakingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMatchmakingConfigurationRequest> {
        /**
         * <p>
         * A unique identifier for the matchmaking configuration. This name is used to identify the configuration
         * associated with a matchmaking request or ticket.
         * </p>
         * 
         * @param name
         *        A unique identifier for the matchmaking configuration. This name is used to identify the configuration
         *        associated with a matchmaking request or ticket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A human-readable description of the matchmaking configuration.
         * </p>
         * 
         * @param description
         *        A human-readable description of the matchmaking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions.
         * Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. Queues can be
         * located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions for matches that are
         * created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>,
         * do not set this parameter.
         * </p>
         * 
         * @param gameSessionQueueArns
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique across all
         *        Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>.
         *        Queues can be located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions
         *        for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set
         *        to <code>STANDALONE</code>, do not set this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionQueueArns(Collection<String> gameSessionQueueArns);

        /**
         * <p>
         * The Amazon Resource Name (<a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to a
         * Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions.
         * Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>. Queues can be
         * located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions for matches that are
         * created with this matchmaking configuration. If <code>FlexMatchMode</code> is set to <code>STANDALONE</code>,
         * do not set this parameter.
         * </p>
         * 
         * @param gameSessionQueueArns
         *        The Amazon Resource Name (<a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html">ARN</a>) that is assigned to
         *        a Amazon GameLift game session queue resource and uniquely identifies it. ARNs are unique across all
         *        Regions. Format is <code>arn:aws:gamelift:&lt;region&gt;::gamesessionqueue/&lt;queue name&gt;</code>.
         *        Queues can be located in any Region. Queues are used to start new Amazon GameLift-hosted game sessions
         *        for matches that are created with this matchmaking configuration. If <code>FlexMatchMode</code> is set
         *        to <code>STANDALONE</code>, do not set this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionQueueArns(String... gameSessionQueueArns);

        /**
         * <p>
         * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. Requests
         * that fail due to timing out can be resubmitted as needed.
         * </p>
         * 
         * @param requestTimeoutSeconds
         *        The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
         *        Requests that fail due to timing out can be resubmitted as needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTimeoutSeconds(Integer requestTimeoutSeconds);

        /**
         * <p>
         * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
         * </p>
         * 
         * @param acceptanceTimeoutSeconds
         *        The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is
         *        required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds);

        /**
         * <p>
         * A flag that determines whether a match that was created with this configuration must be accepted by the
         * matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled, matchmaking
         * tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is
         * waiting for player acceptance.
         * </p>
         * 
         * @param acceptanceRequired
         *        A flag that determines whether a match that was created with this configuration must be accepted by
         *        the matched players. To require acceptance, set to <code>TRUE</code>. With this option enabled,
         *        matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed
         *        potential match is waiting for player acceptance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptanceRequired(Boolean acceptanceRequired);

        /**
         * <p>
         * A unique identifier for the matchmaking rule set to use with this configuration. You can use either the rule
         * set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same
         * Region.
         * </p>
         * 
         * @param ruleSetName
         *        A unique identifier for the matchmaking rule set to use with this configuration. You can use either
         *        the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in
         *        the same Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * An SNS topic ARN that is set up to receive matchmaking notifications. See <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up
         * notifications for matchmaking</a> for more information.
         * </p>
         * 
         * @param notificationTarget
         *        An SNS topic ARN that is set up to receive matchmaking notifications. See <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Setting up
         *        notifications for matchmaking</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTarget(String notificationTarget);

        /**
         * <p>
         * The number of player slots in a match to keep open for future players. For example, if the configuration's
         * rule set specifies a match for a single 10-person team, and the additional player count is set to 2, 10
         * players will be selected for the match and 2 more player slots will be open for future players. This
         * parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * </p>
         * 
         * @param additionalPlayerCount
         *        The number of player slots in a match to keep open for future players. For example, if the
         *        configuration's rule set specifies a match for a single 10-person team, and the additional player
         *        count is set to 2, 10 players will be selected for the match and 2 more player slots will be open for
         *        future players. This parameter is not used if <code>FlexMatchMode</code> is set to
         *        <code>STANDALONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalPlayerCount(Integer additionalPlayerCount);

        /**
         * <p>
         * Information to be added to all events related to this matchmaking configuration.
         * </p>
         * 
         * @param customEventData
         *        Information to be added to all events related to this matchmaking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEventData(String customEventData);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
         * <code>GameSession</code> object that is created for a successful match. This parameter is not used if
         * <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
         *        <code>GameSession</code> object that is created for a successful match. This parameter is not used if
         *        <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(Collection<GameProperty> gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
         * <code>GameSession</code> object that is created for a successful match. This parameter is not used if
         * <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
         *        <code>GameSession</code> object that is created for a successful match. This parameter is not used if
         *        <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(GameProperty... gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. This information is added to the new
         * <code>GameSession</code> object that is created for a successful match. This parameter is not used if
         * <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.GameProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #gameProperties(List<GameProperty>)}.
         * 
         * @param gameProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameProperties(java.util.Collection<GameProperty>)
         */
        Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties);

        /**
         * <p>
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game
         * server process with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that is
         * created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to
         * <code>STANDALONE</code>.
         * </p>
         * 
         * @param gameSessionData
         *        A set of custom game session properties, formatted as a single string value. This data is passed to a
         *        game server process with a request to start a new game session (see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>). This information is added to the new <code>GameSession</code> object that
         *        is created for a successful match. This parameter is not used if <code>FlexMatchMode</code> is set to
         *        <code>STANDALONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionData(String gameSessionData);

        /**
         * <p>
         * The method used to backfill game sessions that are created with this matchmaking configuration. Specify
         * <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill
         * feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game
         * session has one or more open slots. Learn more about manual and automatic backfill in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing
         * Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
         * <code>STANDALONE</code>.
         * </p>
         * 
         * @param backfillMode
         *        The method used to backfill game sessions that are created with this matchmaking configuration.
         *        Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the
         *        match backfill feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill
         *        request whenever a game session has one or more open slots. Learn more about manual and automatic
         *        backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">
         *        Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when
         *        <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * @see BackfillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackfillMode
         */
        Builder backfillMode(String backfillMode);

        /**
         * <p>
         * The method used to backfill game sessions that are created with this matchmaking configuration. Specify
         * <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill
         * feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill request whenever a game
         * session has one or more open slots. Learn more about manual and automatic backfill in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html"> Backfill Existing
         * Games with FlexMatch</a>. Automatic backfill is not available when <code>FlexMatchMode</code> is set to
         * <code>STANDALONE</code>.
         * </p>
         * 
         * @param backfillMode
         *        The method used to backfill game sessions that are created with this matchmaking configuration.
         *        Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the
         *        match backfill feature. Specify <code>AUTOMATIC</code> to have Amazon GameLift create a backfill
         *        request whenever a game session has one or more open slots. Learn more about manual and automatic
         *        backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">
         *        Backfill Existing Games with FlexMatch</a>. Automatic backfill is not available when
         *        <code>FlexMatchMode</code> is set to <code>STANDALONE</code>.
         * @see BackfillMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackfillMode
         */
        Builder backfillMode(BackfillMode backfillMode);

        /**
         * <p>
         * Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
         * standalone matchmaking solution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
         * assignments, in a <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
         * > MatchmakingSucceeded</a> event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game
         * session for the match.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexMatchMode
         *        Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
         *        standalone matchmaking solution. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
         *        assignments, in a <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
         *        > MatchmakingSucceeded</a> event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a
         *        game session for the match.
         *        </p>
         *        </li>
         * @see FlexMatchMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexMatchMode
         */
        Builder flexMatchMode(String flexMatchMode);

        /**
         * <p>
         * Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
         * standalone matchmaking solution.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
         * assignments, in a <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
         * > MatchmakingSucceeded</a> event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a game
         * session for the match.
         * </p>
         * </li>
         * </ul>
         * 
         * @param flexMatchMode
         *        Indicates whether this matchmaking configuration is being used with Amazon GameLift hosting or as a
         *        standalone matchmaking solution. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>STANDALONE</b> - FlexMatch forms matches and returns match information, including players and team
         *        assignments, in a <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded"
         *        > MatchmakingSucceeded</a> event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>WITH_QUEUE</b> - FlexMatch forms matches and uses the specified Amazon GameLift queue to start a
         *        game session for the match.
         *        </p>
         *        </li>
         * @see FlexMatchMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlexMatchMode
         */
        Builder flexMatchMode(FlexMatchMode flexMatchMode);

        /**
         * <p>
         * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         * key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management
         * and cost allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         *        key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
         *        management and cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         * key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management
         * and cost allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         *        key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access
         *        management and cost allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new matchmaking configuration resource. Tags are developer-defined
         * key-value pairs. Tagging Amazon Web Services resources are useful for resource management, access management
         * and cost allocation. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         * Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.gamelift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<String> gameSessionQueueArns = DefaultSdkAutoConstructList.getInstance();

        private Integer requestTimeoutSeconds;

        private Integer acceptanceTimeoutSeconds;

        private Boolean acceptanceRequired;

        private String ruleSetName;

        private String notificationTarget;

        private Integer additionalPlayerCount;

        private String customEventData;

        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private String gameSessionData;

        private String backfillMode;

        private String flexMatchMode;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMatchmakingConfigurationRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            gameSessionQueueArns(model.gameSessionQueueArns);
            requestTimeoutSeconds(model.requestTimeoutSeconds);
            acceptanceTimeoutSeconds(model.acceptanceTimeoutSeconds);
            acceptanceRequired(model.acceptanceRequired);
            ruleSetName(model.ruleSetName);
            notificationTarget(model.notificationTarget);
            additionalPlayerCount(model.additionalPlayerCount);
            customEventData(model.customEventData);
            gameProperties(model.gameProperties);
            gameSessionData(model.gameSessionData);
            backfillMode(model.backfillMode);
            flexMatchMode(model.flexMatchMode);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGameSessionQueueArns() {
            if (gameSessionQueueArns instanceof SdkAutoConstructList) {
                return null;
            }
            return gameSessionQueueArns;
        }

        public final void setGameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
        }

        @Override
        public final Builder gameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueueArns(String... gameSessionQueueArns) {
            gameSessionQueueArns(Arrays.asList(gameSessionQueueArns));
            return this;
        }

        public final Integer getRequestTimeoutSeconds() {
            return requestTimeoutSeconds;
        }

        public final void setRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
        }

        @Override
        public final Builder requestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return this;
        }

        public final Integer getAcceptanceTimeoutSeconds() {
            return acceptanceTimeoutSeconds;
        }

        public final void setAcceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
        }

        @Override
        public final Builder acceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
            return this;
        }

        public final Boolean getAcceptanceRequired() {
            return acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final String getNotificationTarget() {
            return notificationTarget;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        public final Integer getAdditionalPlayerCount() {
            return additionalPlayerCount;
        }

        public final void setAdditionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
        }

        @Override
        public final Builder additionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
            return this;
        }

        public final String getCustomEventData() {
            return customEventData;
        }

        public final void setCustomEventData(String customEventData) {
            this.customEventData = customEventData;
        }

        @Override
        public final Builder customEventData(String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty... gameProperties) {
            gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties) {
            gameProperties(Stream.of(gameProperties).map(c -> GameProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGameSessionData() {
            return gameSessionData;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final String getBackfillMode() {
            return backfillMode;
        }

        public final void setBackfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
        }

        @Override
        public final Builder backfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
            return this;
        }

        @Override
        public final Builder backfillMode(BackfillMode backfillMode) {
            this.backfillMode(backfillMode == null ? null : backfillMode.toString());
            return this;
        }

        public final String getFlexMatchMode() {
            return flexMatchMode;
        }

        public final void setFlexMatchMode(String flexMatchMode) {
            this.flexMatchMode = flexMatchMode;
        }

        @Override
        public final Builder flexMatchMode(String flexMatchMode) {
            this.flexMatchMode = flexMatchMode;
            return this;
        }

        @Override
        public final Builder flexMatchMode(FlexMatchMode flexMatchMode) {
            this.flexMatchMode(flexMatchMode == null ? null : flexMatchMode.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMatchmakingConfigurationRequest build() {
            return new CreateMatchmakingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
