/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * A set of one or more port numbers that can be opened on the container.
 * </p>
 * <p>
 * <b>Part of:</b> <a>ContainerPortConfiguration</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerPortRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerPortRange.Builder, ContainerPortRange> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort").getter(getter(ContainerPortRange::fromPort)).setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort").getter(getter(ContainerPortRange::toPort)).setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(ContainerPortRange::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD,
            TO_PORT_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fromPort;

    private final Integer toPort;

    private final String protocol;

    private ContainerPortRange(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * A starting value for the range of allowed port numbers.
     * </p>
     * 
     * @return A starting value for the range of allowed port numbers.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal
     * to or greater than <code>FromPort</code>.
     * </p>
     * 
     * @return An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be
     *         equal to or greater than <code>FromPort</code>.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The network protocol that these ports support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link IpProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network protocol that these ports support.
     * @see IpProtocol
     */
    public final IpProtocol protocol() {
        return IpProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The network protocol that these ports support.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link IpProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network protocol that these ports support.
     * @see IpProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerPortRange)) {
            return false;
        }
        ContainerPortRange other = (ContainerPortRange) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerPortRange")
                .add("FromPort", fromPort() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ToPort", toPort() == null ? null : "*** Sensitive Data Redacted ***").add("Protocol", protocolAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerPortRange, T> g) {
        return obj -> g.apply((ContainerPortRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerPortRange> {
        /**
         * <p>
         * A starting value for the range of allowed port numbers.
         * </p>
         * 
         * @param fromPort
         *        A starting value for the range of allowed port numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be
         * equal to or greater than <code>FromPort</code>.
         * </p>
         * 
         * @param toPort
         *        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must
         *        be equal to or greater than <code>FromPort</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The network protocol that these ports support.
         * </p>
         * 
         * @param protocol
         *        The network protocol that these ports support.
         * @see IpProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The network protocol that these ports support.
         * </p>
         * 
         * @param protocol
         *        The network protocol that these ports support.
         * @see IpProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpProtocol
         */
        Builder protocol(IpProtocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerPortRange model) {
            fromPort(model.fromPort);
            toPort(model.toPort);
            protocol(model.protocol);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(IpProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public ContainerPortRange build() {
            return new ContainerPortRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
