/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * Determines how many replica container groups that Amazon GameLift deploys to each instance in a container fleet.
 * </p>
 * <p>
 * Amazon GameLift calculates the maximum possible replica groups per instance based on the instance 's CPU and memory
 * resources. When deploying a fleet, Amazon GameLift places replica container groups on each fleet instance based on
 * the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * If no desired value is set, Amazon GameLift places the calculated maximum.
 * </p>
 * </li>
 * <li>
 * <p>
 * If a desired number is set to a value higher than the calculated maximum, Amazon GameLift places the calculated
 * maximum.
 * </p>
 * </li>
 * <li>
 * <p>
 * If a desired number is set to a value lower than the calculated maximum, Amazon GameLift places the desired number.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Part of:</b> <a>ContainerGroupsConfiguration</a>, <a>ContainerGroupsAttributes</a>
 * </p>
 * <p>
 * <b>Returned by:</b> <a>DescribeFleetAttributes</a>, <a>CreateFleet</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerGroupsPerInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerGroupsPerInstance.Builder, ContainerGroupsPerInstance> {
    private static final SdkField<Integer> DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredReplicaContainerGroupsPerInstance")
            .getter(getter(ContainerGroupsPerInstance::desiredReplicaContainerGroupsPerInstance))
            .setter(setter(Builder::desiredReplicaContainerGroupsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DesiredReplicaContainerGroupsPerInstance").build()).build();

    private static final SdkField<Integer> MAX_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxReplicaContainerGroupsPerInstance")
            .getter(getter(ContainerGroupsPerInstance::maxReplicaContainerGroupsPerInstance))
            .setter(setter(Builder::maxReplicaContainerGroupsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MaxReplicaContainerGroupsPerInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESIRED_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD, MAX_REPLICA_CONTAINER_GROUPS_PER_INSTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer desiredReplicaContainerGroupsPerInstance;

    private final Integer maxReplicaContainerGroupsPerInstance;

    private ContainerGroupsPerInstance(BuilderImpl builder) {
        this.desiredReplicaContainerGroupsPerInstance = builder.desiredReplicaContainerGroupsPerInstance;
        this.maxReplicaContainerGroupsPerInstance = builder.maxReplicaContainerGroupsPerInstance;
    }

    /**
     * <p>
     * The desired number of replica container groups to place on each fleet instance.
     * </p>
     * 
     * @return The desired number of replica container groups to place on each fleet instance.
     */
    public final Integer desiredReplicaContainerGroupsPerInstance() {
        return desiredReplicaContainerGroupsPerInstance;
    }

    /**
     * <p>
     * The maximum possible number of replica container groups that each fleet instance can have.
     * </p>
     * 
     * @return The maximum possible number of replica container groups that each fleet instance can have.
     */
    public final Integer maxReplicaContainerGroupsPerInstance() {
        return maxReplicaContainerGroupsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredReplicaContainerGroupsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(maxReplicaContainerGroupsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupsPerInstance)) {
            return false;
        }
        ContainerGroupsPerInstance other = (ContainerGroupsPerInstance) obj;
        return Objects.equals(desiredReplicaContainerGroupsPerInstance(), other.desiredReplicaContainerGroupsPerInstance())
                && Objects.equals(maxReplicaContainerGroupsPerInstance(), other.maxReplicaContainerGroupsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerGroupsPerInstance")
                .add("DesiredReplicaContainerGroupsPerInstance", desiredReplicaContainerGroupsPerInstance())
                .add("MaxReplicaContainerGroupsPerInstance", maxReplicaContainerGroupsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredReplicaContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(desiredReplicaContainerGroupsPerInstance()));
        case "MaxReplicaContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(maxReplicaContainerGroupsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupsPerInstance, T> g) {
        return obj -> g.apply((ContainerGroupsPerInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerGroupsPerInstance> {
        /**
         * <p>
         * The desired number of replica container groups to place on each fleet instance.
         * </p>
         * 
         * @param desiredReplicaContainerGroupsPerInstance
         *        The desired number of replica container groups to place on each fleet instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance);

        /**
         * <p>
         * The maximum possible number of replica container groups that each fleet instance can have.
         * </p>
         * 
         * @param maxReplicaContainerGroupsPerInstance
         *        The maximum possible number of replica container groups that each fleet instance can have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxReplicaContainerGroupsPerInstance(Integer maxReplicaContainerGroupsPerInstance);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredReplicaContainerGroupsPerInstance;

        private Integer maxReplicaContainerGroupsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupsPerInstance model) {
            desiredReplicaContainerGroupsPerInstance(model.desiredReplicaContainerGroupsPerInstance);
            maxReplicaContainerGroupsPerInstance(model.maxReplicaContainerGroupsPerInstance);
        }

        public final Integer getDesiredReplicaContainerGroupsPerInstance() {
            return desiredReplicaContainerGroupsPerInstance;
        }

        public final void setDesiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
        }

        @Override
        public final Builder desiredReplicaContainerGroupsPerInstance(Integer desiredReplicaContainerGroupsPerInstance) {
            this.desiredReplicaContainerGroupsPerInstance = desiredReplicaContainerGroupsPerInstance;
            return this;
        }

        public final Integer getMaxReplicaContainerGroupsPerInstance() {
            return maxReplicaContainerGroupsPerInstance;
        }

        public final void setMaxReplicaContainerGroupsPerInstance(Integer maxReplicaContainerGroupsPerInstance) {
            this.maxReplicaContainerGroupsPerInstance = maxReplicaContainerGroupsPerInstance;
        }

        @Override
        public final Builder maxReplicaContainerGroupsPerInstance(Integer maxReplicaContainerGroupsPerInstance) {
            this.maxReplicaContainerGroupsPerInstance = maxReplicaContainerGroupsPerInstance;
            return this;
        }

        @Override
        public ContainerGroupsPerInstance build() {
            return new ContainerGroupsPerInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
