/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Model performance metrics data points.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDataPoint implements SdkPojo, Serializable, ToCopyableBuilder<MetricDataPoint.Builder, MetricDataPoint> {
    private static final SdkField<Float> FPR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("fpr")
            .getter(getter(MetricDataPoint::fpr)).setter(setter(Builder::fpr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fpr").build()).build();

    private static final SdkField<Float> PRECISION_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("precision").getter(getter(MetricDataPoint::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precision").build()).build();

    private static final SdkField<Float> TPR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("tpr")
            .getter(getter(MetricDataPoint::tpr)).setter(setter(Builder::tpr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tpr").build()).build();

    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("threshold").getter(getter(MetricDataPoint::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPR_FIELD, PRECISION_FIELD,
            TPR_FIELD, THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float fpr;

    private final Float precision;

    private final Float tpr;

    private final Float threshold;

    private MetricDataPoint(BuilderImpl builder) {
        this.fpr = builder.fpr;
        this.precision = builder.precision;
        this.tpr = builder.tpr;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as
     * fraud.
     * </p>
     * 
     * @return The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted
     *         as fraud.
     */
    public final Float fpr() {
        return fpr;
    }

    /**
     * <p>
     * The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as
     * fraudulent.
     * </p>
     * 
     * @return The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as
     *         fraudulent.
     */
    public final Float precision() {
        return precision;
    }

    /**
     * <p>
     * The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.
     * </p>
     * 
     * @return The true positive rate. This is the percentage of total fraud the model detects. Also known as capture
     *         rate.
     */
    public final Float tpr() {
        return tpr;
    }

    /**
     * <p>
     * The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any
     * model score 500 or above is labeled as fraud.
     * </p>
     * 
     * @return The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500
     *         means any model score 500 or above is labeled as fraud.
     */
    public final Float threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpr());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(tpr());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataPoint)) {
            return false;
        }
        MetricDataPoint other = (MetricDataPoint) obj;
        return Objects.equals(fpr(), other.fpr()) && Objects.equals(precision(), other.precision())
                && Objects.equals(tpr(), other.tpr()) && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDataPoint").add("Fpr", fpr()).add("Precision", precision()).add("Tpr", tpr())
                .add("Threshold", threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fpr":
            return Optional.ofNullable(clazz.cast(fpr()));
        case "precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "tpr":
            return Optional.ofNullable(clazz.cast(tpr()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDataPoint, T> g) {
        return obj -> g.apply((MetricDataPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDataPoint> {
        /**
         * <p>
         * The false positive rate. This is the percentage of total legitimate events that are incorrectly predicted as
         * fraud.
         * </p>
         * 
         * @param fpr
         *        The false positive rate. This is the percentage of total legitimate events that are incorrectly
         *        predicted as fraud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpr(Float fpr);

        /**
         * <p>
         * The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted as
         * fraudulent.
         * </p>
         * 
         * @param precision
         *        The percentage of fraud events correctly predicted as fraudulent as compared to all events predicted
         *        as fraudulent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Float precision);

        /**
         * <p>
         * The true positive rate. This is the percentage of total fraud the model detects. Also known as capture rate.
         * </p>
         * 
         * @param tpr
         *        The true positive rate. This is the percentage of total fraud the model detects. Also known as capture
         *        rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tpr(Float tpr);

        /**
         * <p>
         * The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means
         * any model score 500 or above is labeled as fraud.
         * </p>
         * 
         * @param threshold
         *        The model threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500
         *        means any model score 500 or above is labeled as fraud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Float threshold);
    }

    static final class BuilderImpl implements Builder {
        private Float fpr;

        private Float precision;

        private Float tpr;

        private Float threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataPoint model) {
            fpr(model.fpr);
            precision(model.precision);
            tpr(model.tpr);
            threshold(model.threshold);
        }

        public final Float getFpr() {
            return fpr;
        }

        public final void setFpr(Float fpr) {
            this.fpr = fpr;
        }

        @Override
        public final Builder fpr(Float fpr) {
            this.fpr = fpr;
            return this;
        }

        public final Float getPrecision() {
            return precision;
        }

        public final void setPrecision(Float precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Float precision) {
            this.precision = precision;
            return this;
        }

        public final Float getTpr() {
            return tpr;
        }

        public final void setTpr(Float tpr) {
            this.tpr = tpr;
        }

        @Override
        public final Builder tpr(Float tpr) {
            this.tpr = tpr;
            return this;
        }

        public final Float getThreshold() {
            return threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public MetricDataPoint build() {
            return new MetricDataPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
