/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelVersionResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetModelVersionResponse.Builder, GetModelVersionResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(GetModelVersionResponse::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelType").getter(getter(GetModelVersionResponse::modelTypeAsString))
            .setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelVersionNumber").getter(getter(GetModelVersionResponse::modelVersionNumber))
            .setter(setter(Builder::modelVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build())
            .build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDataSource").getter(getter(GetModelVersionResponse::trainingDataSourceAsString))
            .setter(setter(Builder::trainingDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build())
            .build();

    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField
            .<TrainingDataSchema> builder(MarshallingType.SDK_POJO).memberName("trainingDataSchema")
            .getter(getter(GetModelVersionResponse::trainingDataSchema)).setter(setter(Builder::trainingDataSchema))
            .constructor(TrainingDataSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build())
            .build();

    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField
            .<ExternalEventsDetail> builder(MarshallingType.SDK_POJO).memberName("externalEventsDetail")
            .getter(getter(GetModelVersionResponse::externalEventsDetail)).setter(setter(Builder::externalEventsDetail))
            .constructor(ExternalEventsDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build())
            .build();

    private static final SdkField<IngestedEventsDetail> INGESTED_EVENTS_DETAIL_FIELD = SdkField
            .<IngestedEventsDetail> builder(MarshallingType.SDK_POJO).memberName("ingestedEventsDetail")
            .getter(getter(GetModelVersionResponse::ingestedEventsDetail)).setter(setter(Builder::ingestedEventsDetail))
            .constructor(IngestedEventsDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestedEventsDetail").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetModelVersionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetModelVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD,
            EXTERNAL_EVENTS_DETAIL_FIELD, INGESTED_EVENTS_DETAIL_FIELD, STATUS_FIELD, ARN_FIELD));

    private final String modelId;

    private final String modelType;

    private final String modelVersionNumber;

    private final String trainingDataSource;

    private final TrainingDataSchema trainingDataSchema;

    private final ExternalEventsDetail externalEventsDetail;

    private final IngestedEventsDetail ingestedEventsDetail;

    private final String status;

    private final String arn;

    private GetModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.ingestedEventsDetail = builder.ingestedEventsDetail;
        this.status = builder.status;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The model version number.
     * </p>
     * 
     * @return The model version number.
     */
    public final String modelVersionNumber() {
        return modelVersionNumber;
    }

    /**
     * <p>
     * The training data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The training data source.
     * @see TrainingDataSourceEnum
     */
    public final TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(trainingDataSource);
    }

    /**
     * <p>
     * The training data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The training data source.
     * @see TrainingDataSourceEnum
     */
    public final String trainingDataSourceAsString() {
        return trainingDataSource;
    }

    /**
     * <p>
     * The training data schema.
     * </p>
     * 
     * @return The training data schema.
     */
    public final TrainingDataSchema trainingDataSchema() {
        return trainingDataSchema;
    }

    /**
     * <p>
     * The details of the external events data used for training the model version. This will be populated if the
     * <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>
     * </p>
     * 
     * @return The details of the external events data used for training the model version. This will be populated if
     *         the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>
     */
    public final ExternalEventsDetail externalEventsDetail() {
        return externalEventsDetail;
    }

    /**
     * <p>
     * The details of the ingested events data used for training the model version. This will be populated if the
     * <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.
     * </p>
     * 
     * @return The details of the ingested events data used for training the model version. This will be populated if
     *         the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.
     */
    public final IngestedEventsDetail ingestedEventsDetail() {
        return ingestedEventsDetail;
    }

    /**
     * <p>
     * The model version status.
     * </p>
     * <p>
     * Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRAINING_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRAINING_COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATE_REQUESTED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVATE_REQUESTED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The model version status.</p>
     *         <p>
     *         Possible values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRAINING_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRAINING_COMPLETE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATE_REQUESTED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVATE_REQUESTED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The model version ARN.
     * </p>
     * 
     * @return The model version ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(ingestedEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelVersionResponse)) {
            return false;
        }
        GetModelVersionResponse other = (GetModelVersionResponse) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(modelVersionNumber(), other.modelVersionNumber())
                && Objects.equals(trainingDataSourceAsString(), other.trainingDataSourceAsString())
                && Objects.equals(trainingDataSchema(), other.trainingDataSchema())
                && Objects.equals(externalEventsDetail(), other.externalEventsDetail())
                && Objects.equals(ingestedEventsDetail(), other.ingestedEventsDetail())
                && Objects.equals(status(), other.status()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetModelVersionResponse").add("ModelId", modelId()).add("ModelType", modelTypeAsString())
                .add("ModelVersionNumber", modelVersionNumber()).add("TrainingDataSource", trainingDataSourceAsString())
                .add("TrainingDataSchema", trainingDataSchema()).add("ExternalEventsDetail", externalEventsDetail())
                .add("IngestedEventsDetail", ingestedEventsDetail()).add("Status", status()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "modelVersionNumber":
            return Optional.ofNullable(clazz.cast(modelVersionNumber()));
        case "trainingDataSource":
            return Optional.ofNullable(clazz.cast(trainingDataSourceAsString()));
        case "trainingDataSchema":
            return Optional.ofNullable(clazz.cast(trainingDataSchema()));
        case "externalEventsDetail":
            return Optional.ofNullable(clazz.cast(externalEventsDetail()));
        case "ingestedEventsDetail":
            return Optional.ofNullable(clazz.cast(ingestedEventsDetail()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelVersionResponse, T> g) {
        return obj -> g.apply((GetModelVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetModelVersionResponse> {
        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The model version number.
         * </p>
         * 
         * @param modelVersionNumber
         *        The model version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionNumber(String modelVersionNumber);

        /**
         * <p>
         * The training data source.
         * </p>
         * 
         * @param trainingDataSource
         *        The training data source.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(String trainingDataSource);

        /**
         * <p>
         * The training data source.
         * </p>
         * 
         * @param trainingDataSource
         *        The training data source.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource);

        /**
         * <p>
         * The training data schema.
         * </p>
         * 
         * @param trainingDataSchema
         *        The training data schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSchema(TrainingDataSchema trainingDataSchema);

        /**
         * <p>
         * The training data schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDataSchema.Builder} avoiding the
         * need to create one manually via {@link TrainingDataSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDataSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataSchema(TrainingDataSchema)}.
         * 
         * @param trainingDataSchema
         *        a consumer that will call methods on {@link TrainingDataSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataSchema(TrainingDataSchema)
         */
        default Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return trainingDataSchema(TrainingDataSchema.builder().applyMutation(trainingDataSchema).build());
        }

        /**
         * <p>
         * The details of the external events data used for training the model version. This will be populated if the
         * <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>
         * </p>
         * 
         * @param externalEventsDetail
         *        The details of the external events data used for training the model version. This will be populated if
         *        the <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail);

        /**
         * <p>
         * The details of the external events data used for training the model version. This will be populated if the
         * <code>trainingDataSource</code> is <code>EXTERNAL_EVENTS</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalEventsDetail.Builder} avoiding
         * the need to create one manually via {@link ExternalEventsDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalEventsDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #externalEventsDetail(ExternalEventsDetail)}.
         * 
         * @param externalEventsDetail
         *        a consumer that will call methods on {@link ExternalEventsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalEventsDetail(ExternalEventsDetail)
         */
        default Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return externalEventsDetail(ExternalEventsDetail.builder().applyMutation(externalEventsDetail).build());
        }

        /**
         * <p>
         * The details of the ingested events data used for training the model version. This will be populated if the
         * <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.
         * </p>
         * 
         * @param ingestedEventsDetail
         *        The details of the ingested events data used for training the model version. This will be populated if
         *        the <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestedEventsDetail(IngestedEventsDetail ingestedEventsDetail);

        /**
         * <p>
         * The details of the ingested events data used for training the model version. This will be populated if the
         * <code>trainingDataSource</code> is <code>INGESTED_EVENTS</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestedEventsDetail.Builder} avoiding
         * the need to create one manually via {@link IngestedEventsDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestedEventsDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestedEventsDetail(IngestedEventsDetail)}.
         * 
         * @param ingestedEventsDetail
         *        a consumer that will call methods on {@link IngestedEventsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestedEventsDetail(IngestedEventsDetail)
         */
        default Builder ingestedEventsDetail(Consumer<IngestedEventsDetail.Builder> ingestedEventsDetail) {
            return ingestedEventsDetail(IngestedEventsDetail.builder().applyMutation(ingestedEventsDetail).build());
        }

        /**
         * <p>
         * The model version status.
         * </p>
         * <p>
         * Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRAINING_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRAINING_COMPLETE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATE_REQUESTED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVATE_REQUESTED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The model version status.</p>
         *        <p>
         *        Possible values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRAINING_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRAINING_COMPLETE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATE_REQUESTED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVATE_REQUESTED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The model version ARN.
         * </p>
         * 
         * @param arn
         *        The model version ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String modelId;

        private String modelType;

        private String modelVersionNumber;

        private String trainingDataSource;

        private TrainingDataSchema trainingDataSchema;

        private ExternalEventsDetail externalEventsDetail;

        private IngestedEventsDetail ingestedEventsDetail;

        private String status;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelVersionResponse model) {
            super(model);
            modelId(model.modelId);
            modelType(model.modelType);
            modelVersionNumber(model.modelVersionNumber);
            trainingDataSource(model.trainingDataSource);
            trainingDataSchema(model.trainingDataSchema);
            externalEventsDetail(model.externalEventsDetail);
            ingestedEventsDetail(model.ingestedEventsDetail);
            status(model.status);
            arn(model.arn);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelType() {
            return modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getModelVersionNumber() {
            return modelVersionNumber;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final String getTrainingDataSource() {
            return trainingDataSource;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        @Override
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return trainingDataSchema != null ? trainingDataSchema.toBuilder() : null;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        @Override
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return externalEventsDetail != null ? externalEventsDetail.toBuilder() : null;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        @Override
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final IngestedEventsDetail.Builder getIngestedEventsDetail() {
            return ingestedEventsDetail != null ? ingestedEventsDetail.toBuilder() : null;
        }

        public final void setIngestedEventsDetail(IngestedEventsDetail.BuilderImpl ingestedEventsDetail) {
            this.ingestedEventsDetail = ingestedEventsDetail != null ? ingestedEventsDetail.build() : null;
        }

        @Override
        public final Builder ingestedEventsDetail(IngestedEventsDetail ingestedEventsDetail) {
            this.ingestedEventsDetail = ingestedEventsDetail;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetModelVersionResponse build() {
            return new GetModelVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
