/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the summary of an event prediction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventPredictionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EventPredictionSummary.Builder, EventPredictionSummary> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(EventPredictionSummary::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(EventPredictionSummary::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTimestamp").getter(getter(EventPredictionSummary::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("predictionTimestamp").getter(getter(EventPredictionSummary::predictionTimestamp))
            .setter(setter(Builder::predictionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build())
            .build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(EventPredictionSummary::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(EventPredictionSummary::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, EVENT_TIMESTAMP_FIELD, PREDICTION_TIMESTAMP_FIELD, DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String eventTypeName;

    private final String eventTimestamp;

    private final String predictionTimestamp;

    private final String detectorId;

    private final String detectorVersionId;

    private EventPredictionSummary(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.eventTimestamp = builder.eventTimestamp;
        this.predictionTimestamp = builder.predictionTimestamp;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * 
     * @return The event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The timestamp of the event.
     * </p>
     * 
     * @return The timestamp of the event.
     */
    public final String eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * <p>
     * The timestamp when the prediction was generated.
     * </p>
     * 
     * @return The timestamp when the prediction was generated.
     */
    public final String predictionTimestamp() {
        return predictionTimestamp;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventPredictionSummary)) {
            return false;
        }
        EventPredictionSummary other = (EventPredictionSummary) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(eventTimestamp(), other.eventTimestamp())
                && Objects.equals(predictionTimestamp(), other.predictionTimestamp())
                && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(detectorVersionId(), other.detectorVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventPredictionSummary").add("EventId", eventId()).add("EventTypeName", eventTypeName())
                .add("EventTimestamp", eventTimestamp()).add("PredictionTimestamp", predictionTimestamp())
                .add("DetectorId", detectorId()).add("DetectorVersionId", detectorVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "predictionTimestamp":
            return Optional.ofNullable(clazz.cast(predictionTimestamp()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventPredictionSummary, T> g) {
        return obj -> g.apply((EventPredictionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventPredictionSummary> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventTypeName
         *        The event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The timestamp of the event.
         * </p>
         * 
         * @param eventTimestamp
         *        The timestamp of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(String eventTimestamp);

        /**
         * <p>
         * The timestamp when the prediction was generated.
         * </p>
         * 
         * @param predictionTimestamp
         *        The timestamp when the prediction was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimestamp(String predictionTimestamp);

        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private String eventTimestamp;

        private String predictionTimestamp;

        private String detectorId;

        private String detectorVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventPredictionSummary model) {
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            eventTimestamp(model.eventTimestamp);
            predictionTimestamp(model.predictionTimestamp);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getPredictionTimestamp() {
            return predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        @Override
        public EventPredictionSummary build() {
            return new EventPredictionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
