/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveTrustStoreRevocationsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<RemoveTrustStoreRevocationsRequest.Builder, RemoveTrustStoreRevocationsRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(RemoveTrustStoreRevocationsRequest::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<List<Long>> REVOCATION_IDS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("RevocationIds")
            .getter(getter(RemoveTrustStoreRevocationsRequest::revocationIds))
            .setter(setter(Builder::revocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD,
            REVOCATION_IDS_FIELD));

    private final String trustStoreArn;

    private final List<Long> revocationIds;

    private RemoveTrustStoreRevocationsRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationIds = builder.revocationIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevocationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevocationIds() {
        return revocationIds != null && !(revocationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The revocation IDs of the revocation files you want to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevocationIds} method.
     * </p>
     * 
     * @return The revocation IDs of the revocation files you want to remove.
     */
    public final List<Long> revocationIds() {
        return revocationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRevocationIds() ? revocationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTrustStoreRevocationsRequest)) {
            return false;
        }
        RemoveTrustStoreRevocationsRequest other = (RemoveTrustStoreRevocationsRequest) obj;
        return Objects.equals(trustStoreArn(), other.trustStoreArn()) && hasRevocationIds() == other.hasRevocationIds()
                && Objects.equals(revocationIds(), other.revocationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveTrustStoreRevocationsRequest").add("TrustStoreArn", trustStoreArn())
                .add("RevocationIds", hasRevocationIds() ? revocationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "RevocationIds":
            return Optional.ofNullable(clazz.cast(revocationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTrustStoreRevocationsRequest, T> g) {
        return obj -> g.apply((RemoveTrustStoreRevocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveTrustStoreRevocationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The revocation IDs of the revocation files you want to remove.
         * </p>
         * 
         * @param revocationIds
         *        The revocation IDs of the revocation files you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationIds(Collection<Long> revocationIds);

        /**
         * <p>
         * The revocation IDs of the revocation files you want to remove.
         * </p>
         * 
         * @param revocationIds
         *        The revocation IDs of the revocation files you want to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationIds(Long... revocationIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String trustStoreArn;

        private List<Long> revocationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTrustStoreRevocationsRequest model) {
            super(model);
            trustStoreArn(model.trustStoreArn);
            revocationIds(model.revocationIds);
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Collection<Long> getRevocationIds() {
            if (revocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return revocationIds;
        }

        public final void setRevocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
        }

        @Override
        public final Builder revocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationIds(Long... revocationIds) {
            revocationIds(Arrays.asList(revocationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTrustStoreRevocationsRequest build() {
            return new RemoveTrustStoreRevocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
