/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(CreateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(CreateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateUserRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Passwords")
            .getter(getter(CreateUserRequest::passwords))
            .setter(setter(Builder::passwords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(CreateUserRequest::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final SdkField<Boolean> NO_PASSWORD_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoPasswordRequired").getter(getter(CreateUserRequest::noPasswordRequired))
            .setter(setter(Builder::noPasswordRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoPasswordRequired").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateUserRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<AuthenticationMode> AUTHENTICATION_MODE_FIELD = SdkField
            .<AuthenticationMode> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMode")
            .getter(getter(CreateUserRequest::authenticationMode)).setter(setter(Builder::authenticationMode))
            .constructor(AuthenticationMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            USER_NAME_FIELD, ENGINE_FIELD, PASSWORDS_FIELD, ACCESS_STRING_FIELD, NO_PASSWORD_REQUIRED_FIELD, TAGS_FIELD,
            AUTHENTICATION_MODE_FIELD));

    private final String userId;

    private final String userName;

    private final String engine;

    private final List<String> passwords;

    private final String accessString;

    private final Boolean noPasswordRequired;

    private final List<Tag> tags;

    private final AuthenticationMode authenticationMode;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.engine = builder.engine;
        this.passwords = builder.passwords;
        this.accessString = builder.accessString;
        this.noPasswordRequired = builder.noPasswordRequired;
        this.tags = builder.tags;
        this.authenticationMode = builder.authenticationMode;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The username of the user.
     * </p>
     * 
     * @return The username of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The current supported value is Redis.
     * </p>
     * 
     * @return The current supported value is Redis.
     */
    public final String engine() {
        return engine;
    }

    /**
     * For responses, this returns true if the service returned a value for the Passwords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPasswords() {
        return passwords != null && !(passwords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Passwords used for this user. You can create up to two passwords for each user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPasswords} method.
     * </p>
     * 
     * @return Passwords used for this user. You can create up to two passwords for each user.
     */
    public final List<String> passwords() {
        return passwords;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    /**
     * <p>
     * Indicates a password is not required for this user.
     * </p>
     * 
     * @return Indicates a password is not required for this user.
     */
    public final Boolean noPasswordRequired() {
        return noPasswordRequired;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag
     * value, although null is accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by
     *         a tag value, although null is accepted.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies how to authenticate the user.
     * </p>
     * 
     * @return Specifies how to authenticate the user.
     */
    public final AuthenticationMode authenticationMode() {
        return authenticationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasPasswords() ? passwords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        hashCode = 31 * hashCode + Objects.hashCode(noPasswordRequired());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(engine(), other.engine()) && hasPasswords() == other.hasPasswords()
                && Objects.equals(passwords(), other.passwords()) && Objects.equals(accessString(), other.accessString())
                && Objects.equals(noPasswordRequired(), other.noPasswordRequired()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(authenticationMode(), other.authenticationMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("UserId", userId()).add("UserName", userName()).add("Engine", engine())
                .add("Passwords", hasPasswords() ? passwords() : null).add("AccessString", accessString())
                .add("NoPasswordRequired", noPasswordRequired()).add("Tags", hasTags() ? tags() : null)
                .add("AuthenticationMode", authenticationMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "Passwords":
            return Optional.ofNullable(clazz.cast(passwords()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        case "NoPasswordRequired":
            return Optional.ofNullable(clazz.cast(noPasswordRequired()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AuthenticationMode":
            return Optional.ofNullable(clazz.cast(authenticationMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The username of the user.
         * </p>
         * 
         * @param userName
         *        The username of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The current supported value is Redis.
         * </p>
         * 
         * @param engine
         *        The current supported value is Redis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Passwords used for this user. You can create up to two passwords for each user.
         * </p>
         * 
         * @param passwords
         *        Passwords used for this user. You can create up to two passwords for each user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(Collection<String> passwords);

        /**
         * <p>
         * Passwords used for this user. You can create up to two passwords for each user.
         * </p>
         * 
         * @param passwords
         *        Passwords used for this user. You can create up to two passwords for each user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(String... passwords);

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        /**
         * <p>
         * Indicates a password is not required for this user.
         * </p>
         * 
         * @param noPasswordRequired
         *        Indicates a password is not required for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noPasswordRequired(Boolean noPasswordRequired);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.elasticache.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies how to authenticate the user.
         * </p>
         * 
         * @param authenticationMode
         *        Specifies how to authenticate the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMode(AuthenticationMode authenticationMode);

        /**
         * <p>
         * Specifies how to authenticate the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMode.Builder} avoiding the
         * need to create one manually via {@link AuthenticationMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationMode.Builder#build()} is called immediately and its
         * result is passed to {@link #authenticationMode(AuthenticationMode)}.
         * 
         * @param authenticationMode
         *        a consumer that will call methods on {@link AuthenticationMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMode(AuthenticationMode)
         */
        default Builder authenticationMode(Consumer<AuthenticationMode.Builder> authenticationMode) {
            return authenticationMode(AuthenticationMode.builder().applyMutation(authenticationMode).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String userId;

        private String userName;

        private String engine;

        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();

        private String accessString;

        private Boolean noPasswordRequired;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private AuthenticationMode authenticationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            userId(model.userId);
            userName(model.userName);
            engine(model.engine);
            passwords(model.passwords);
            accessString(model.accessString);
            noPasswordRequired(model.noPasswordRequired);
            tags(model.tags);
            authenticationMode(model.authenticationMode);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Collection<String> getPasswords() {
            if (passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return passwords;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String... passwords) {
            passwords(Arrays.asList(passwords));
            return this;
        }

        public final String getAccessString() {
            return accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final Boolean getNoPasswordRequired() {
            return noPasswordRequired;
        }

        public final void setNoPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
        }

        @Override
        public final Builder noPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AuthenticationMode.Builder getAuthenticationMode() {
            return authenticationMode != null ? authenticationMode.toBuilder() : null;
        }

        public final void setAuthenticationMode(AuthenticationMode.BuilderImpl authenticationMode) {
            this.authenticationMode = authenticationMode != null ? authenticationMode.build() : null;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
