/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePredefinedAttributeRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdatePredefinedAttributeRequest.Builder, UpdatePredefinedAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdatePredefinedAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdatePredefinedAttributeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<PredefinedAttributeValues> VALUES_FIELD = SdkField
            .<PredefinedAttributeValues> builder(MarshallingType.SDK_POJO).memberName("Values")
            .getter(getter(UpdatePredefinedAttributeRequest::values)).setter(setter(Builder::values))
            .constructor(PredefinedAttributeValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            VALUES_FIELD));

    private final String instanceId;

    private final String name;

    private final PredefinedAttributeValues values;

    private UpdatePredefinedAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.values = builder.values;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the predefined attribute.
     * </p>
     * 
     * @return The name of the predefined attribute.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The values of the predefined attribute.
     * </p>
     * 
     * @return The values of the predefined attribute.
     */
    public final PredefinedAttributeValues values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePredefinedAttributeRequest)) {
            return false;
        }
        UpdatePredefinedAttributeRequest other = (UpdatePredefinedAttributeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePredefinedAttributeRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Values", values()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePredefinedAttributeRequest, T> g) {
        return obj -> g.apply((UpdatePredefinedAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePredefinedAttributeRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the predefined attribute.
         * </p>
         * 
         * @param name
         *        The name of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * 
         * @param values
         *        The values of the predefined attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(PredefinedAttributeValues values);

        /**
         * <p>
         * The values of the predefined attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedAttributeValues.Builder}
         * avoiding the need to create one manually via {@link PredefinedAttributeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedAttributeValues.Builder#build()} is called immediately
         * and its result is passed to {@link #values(PredefinedAttributeValues)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link PredefinedAttributeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(PredefinedAttributeValues)
         */
        default Builder values(Consumer<PredefinedAttributeValues.Builder> values) {
            return values(PredefinedAttributeValues.builder().applyMutation(values).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private PredefinedAttributeValues values;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePredefinedAttributeRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            values(model.values);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PredefinedAttributeValues.Builder getValues() {
            return values != null ? values.toBuilder() : null;
        }

        public final void setValues(PredefinedAttributeValues.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(PredefinedAttributeValues values) {
            this.values = values;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePredefinedAttributeRequest build() {
            return new UpdatePredefinedAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
