/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePhoneNumberRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdatePhoneNumberRequest.Builder, UpdatePhoneNumberRequest> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(UpdatePhoneNumberRequest::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PhoneNumberId").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(UpdatePhoneNumberRequest::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdatePhoneNumberRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdatePhoneNumberRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            TARGET_ARN_FIELD, INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD));

    private final String phoneNumberId;

    private final String targetArn;

    private final String instanceId;

    private final String clientToken;

    private UpdatePhoneNumberRequest(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.targetArn = builder.targetArn;
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A unique identifier for the phone number.
     * </p>
     * 
     * @return A unique identifier for the phone number.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
     * inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
     *         number inbound traffic is routed through. You must enter <code>InstanceId</code> or
     *         <code>TargetArn</code>.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
     *         <code>TargetArn</code>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberRequest)) {
            return false;
        }
        UpdatePhoneNumberRequest other = (UpdatePhoneNumberRequest) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId()) && Objects.equals(targetArn(), other.targetArn())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePhoneNumberRequest").add("PhoneNumberId", phoneNumberId()).add("TargetArn", targetArn())
                .add("InstanceId", instanceId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberRequest, T> g) {
        return obj -> g.apply((UpdatePhoneNumberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePhoneNumberRequest> {
        /**
         * <p>
         * A unique identifier for the phone number.
         * </p>
         * 
         * @param phoneNumberId
         *        A unique identifier for the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
         * inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
         *        number inbound traffic is routed through. You must enter <code>InstanceId</code> or
         *        <code>TargetArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
         * <code>TargetArn</code>.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or
         *        <code>TargetArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String phoneNumberId;

        private String targetArn;

        private String instanceId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberRequest model) {
            super(model);
            phoneNumberId(model.phoneNumberId);
            targetArn(model.targetArn);
            instanceId(model.instanceId);
            clientToken(model.clientToken);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePhoneNumberRequest build() {
            return new UpdatePhoneNumberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
