/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure of search criteria to be used to return contacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchCriteria implements SdkPojo, Serializable, ToCopyableBuilder<SearchCriteria.Builder, SearchCriteria> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentIds")
            .getter(getter(SearchCriteria::agentIds))
            .setter(setter(Builder::agentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AgentHierarchyGroups> AGENT_HIERARCHY_GROUPS_FIELD = SdkField
            .<AgentHierarchyGroups> builder(MarshallingType.SDK_POJO).memberName("AgentHierarchyGroups")
            .getter(getter(SearchCriteria::agentHierarchyGroups)).setter(setter(Builder::agentHierarchyGroups))
            .constructor(AgentHierarchyGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentHierarchyGroups").build())
            .build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(SearchCriteria::channelsAsStrings))
            .setter(setter(Builder::channelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContactAnalysis> CONTACT_ANALYSIS_FIELD = SdkField
            .<ContactAnalysis> builder(MarshallingType.SDK_POJO).memberName("ContactAnalysis")
            .getter(getter(SearchCriteria::contactAnalysis)).setter(setter(Builder::contactAnalysis))
            .constructor(ContactAnalysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAnalysis").build()).build();

    private static final SdkField<List<String>> INITIATION_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InitiationMethods")
            .getter(getter(SearchCriteria::initiationMethodsAsStrings))
            .setter(setter(Builder::initiationMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> QUEUE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueueIds")
            .getter(getter(SearchCriteria::queueIds))
            .setter(setter(Builder::queueIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchableContactAttributes> SEARCHABLE_CONTACT_ATTRIBUTES_FIELD = SdkField
            .<SearchableContactAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("SearchableContactAttributes")
            .getter(getter(SearchCriteria::searchableContactAttributes))
            .setter(setter(Builder::searchableContactAttributes))
            .constructor(SearchableContactAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchableContactAttributes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD,
            AGENT_HIERARCHY_GROUPS_FIELD, CHANNELS_FIELD, CONTACT_ANALYSIS_FIELD, INITIATION_METHODS_FIELD, QUEUE_IDS_FIELD,
            SEARCHABLE_CONTACT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> agentIds;

    private final AgentHierarchyGroups agentHierarchyGroups;

    private final List<String> channels;

    private final ContactAnalysis contactAnalysis;

    private final List<String> initiationMethods;

    private final List<String> queueIds;

    private final SearchableContactAttributes searchableContactAttributes;

    private SearchCriteria(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
        this.agentHierarchyGroups = builder.agentHierarchyGroups;
        this.channels = builder.channels;
        this.contactAnalysis = builder.contactAnalysis;
        this.initiationMethods = builder.initiationMethods;
        this.queueIds = builder.queueIds;
        this.searchableContactAttributes = builder.searchableContactAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentIds() {
        return agentIds != null && !(agentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of agents who handled the contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentIds} method.
     * </p>
     * 
     * @return The identifiers of agents who handled the contacts.
     */
    public final List<String> agentIds() {
        return agentIds;
    }

    /**
     * <p>
     * The agent hierarchy groups of the agent at the time of handling the contact.
     * </p>
     * 
     * @return The agent hierarchy groups of the agent at the time of handling the contact.
     */
    public final AgentHierarchyGroups agentHierarchyGroups() {
        return agentHierarchyGroups;
    }

    /**
     * <p>
     * The list of channels associated with contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The list of channels associated with contacts.
     */
    public final List<Channel> channels() {
        return ChannelListCopier.copyStringToEnum(channels);
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of channels associated with contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return The list of channels associated with contacts.
     */
    public final List<String> channelsAsStrings() {
        return channels;
    }

    /**
     * <p>
     * Search criteria based on analysis outputs from Amazon Connect Contact Lens.
     * </p>
     * 
     * @return Search criteria based on analysis outputs from Amazon Connect Contact Lens.
     */
    public final ContactAnalysis contactAnalysis() {
        return contactAnalysis;
    }

    /**
     * <p>
     * The list of initiation methods associated with contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitiationMethods} method.
     * </p>
     * 
     * @return The list of initiation methods associated with contacts.
     */
    public final List<ContactInitiationMethod> initiationMethods() {
        return InitiationMethodListCopier.copyStringToEnum(initiationMethods);
    }

    /**
     * For responses, this returns true if the service returned a value for the InitiationMethods property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitiationMethods() {
        return initiationMethods != null && !(initiationMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of initiation methods associated with contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitiationMethods} method.
     * </p>
     * 
     * @return The list of initiation methods associated with contacts.
     */
    public final List<String> initiationMethodsAsStrings() {
        return initiationMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueueIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueueIds() {
        return queueIds != null && !(queueIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of queue IDs associated with contacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueueIds} method.
     * </p>
     * 
     * @return The list of queue IDs associated with contacts.
     */
    public final List<String> queueIds() {
        return queueIds;
    }

    /**
     * <p>
     * The search criteria based on user-defined contact attributes that have been configured for contact search. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by custom
     * contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * To use <code>SearchableContactAttributes</code> in a search request, the <code>GetContactAttributes</code> action
     * is required to perform an API request. For more information, see <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions"
     * >https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions
     * -as-permissions</a>Actions defined by Amazon Connect.
     * </p>
     * </important>
     * 
     * @return The search criteria based on user-defined contact attributes that have been configured for contact
     *         search. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by
     *         custom contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <important>
     *         <p>
     *         To use <code>SearchableContactAttributes</code> in a search request, the
     *         <code>GetContactAttributes</code> action is required to perform an API request. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions"
     *         >https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect
     *         -actions-as-permissions</a>Actions defined by Amazon Connect.
     *         </p>
     */
    public final SearchableContactAttributes searchableContactAttributes() {
        return searchableContactAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentIds() ? agentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentHierarchyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(hasInitiationMethods() ? initiationMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueIds() ? queueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(searchableContactAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria) obj;
        return hasAgentIds() == other.hasAgentIds() && Objects.equals(agentIds(), other.agentIds())
                && Objects.equals(agentHierarchyGroups(), other.agentHierarchyGroups()) && hasChannels() == other.hasChannels()
                && Objects.equals(channelsAsStrings(), other.channelsAsStrings())
                && Objects.equals(contactAnalysis(), other.contactAnalysis())
                && hasInitiationMethods() == other.hasInitiationMethods()
                && Objects.equals(initiationMethodsAsStrings(), other.initiationMethodsAsStrings())
                && hasQueueIds() == other.hasQueueIds() && Objects.equals(queueIds(), other.queueIds())
                && Objects.equals(searchableContactAttributes(), other.searchableContactAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchCriteria").add("AgentIds", hasAgentIds() ? agentIds() : null)
                .add("AgentHierarchyGroups", agentHierarchyGroups()).add("Channels", hasChannels() ? channelsAsStrings() : null)
                .add("ContactAnalysis", contactAnalysis())
                .add("InitiationMethods", hasInitiationMethods() ? initiationMethodsAsStrings() : null)
                .add("QueueIds", hasQueueIds() ? queueIds() : null)
                .add("SearchableContactAttributes", searchableContactAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentIds":
            return Optional.ofNullable(clazz.cast(agentIds()));
        case "AgentHierarchyGroups":
            return Optional.ofNullable(clazz.cast(agentHierarchyGroups()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channelsAsStrings()));
        case "ContactAnalysis":
            return Optional.ofNullable(clazz.cast(contactAnalysis()));
        case "InitiationMethods":
            return Optional.ofNullable(clazz.cast(initiationMethodsAsStrings()));
        case "QueueIds":
            return Optional.ofNullable(clazz.cast(queueIds()));
        case "SearchableContactAttributes":
            return Optional.ofNullable(clazz.cast(searchableContactAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchCriteria, T> g) {
        return obj -> g.apply((SearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchCriteria> {
        /**
         * <p>
         * The identifiers of agents who handled the contacts.
         * </p>
         * 
         * @param agentIds
         *        The identifiers of agents who handled the contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(Collection<String> agentIds);

        /**
         * <p>
         * The identifiers of agents who handled the contacts.
         * </p>
         * 
         * @param agentIds
         *        The identifiers of agents who handled the contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIds(String... agentIds);

        /**
         * <p>
         * The agent hierarchy groups of the agent at the time of handling the contact.
         * </p>
         * 
         * @param agentHierarchyGroups
         *        The agent hierarchy groups of the agent at the time of handling the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHierarchyGroups(AgentHierarchyGroups agentHierarchyGroups);

        /**
         * <p>
         * The agent hierarchy groups of the agent at the time of handling the contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentHierarchyGroups.Builder} avoiding
         * the need to create one manually via {@link AgentHierarchyGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentHierarchyGroups.Builder#build()} is called immediately and
         * its result is passed to {@link #agentHierarchyGroups(AgentHierarchyGroups)}.
         * 
         * @param agentHierarchyGroups
         *        a consumer that will call methods on {@link AgentHierarchyGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentHierarchyGroups(AgentHierarchyGroups)
         */
        default Builder agentHierarchyGroups(Consumer<AgentHierarchyGroups.Builder> agentHierarchyGroups) {
            return agentHierarchyGroups(AgentHierarchyGroups.builder().applyMutation(agentHierarchyGroups).build());
        }

        /**
         * <p>
         * The list of channels associated with contacts.
         * </p>
         * 
         * @param channels
         *        The list of channels associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(Collection<String> channels);

        /**
         * <p>
         * The list of channels associated with contacts.
         * </p>
         * 
         * @param channels
         *        The list of channels associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(String... channels);

        /**
         * <p>
         * The list of channels associated with contacts.
         * </p>
         * 
         * @param channels
         *        The list of channels associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * <p>
         * The list of channels associated with contacts.
         * </p>
         * 
         * @param channels
         *        The list of channels associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);

        /**
         * <p>
         * Search criteria based on analysis outputs from Amazon Connect Contact Lens.
         * </p>
         * 
         * @param contactAnalysis
         *        Search criteria based on analysis outputs from Amazon Connect Contact Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactAnalysis(ContactAnalysis contactAnalysis);

        /**
         * <p>
         * Search criteria based on analysis outputs from Amazon Connect Contact Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactAnalysis.Builder} avoiding the
         * need to create one manually via {@link ContactAnalysis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactAnalysis.Builder#build()} is called immediately and its
         * result is passed to {@link #contactAnalysis(ContactAnalysis)}.
         * 
         * @param contactAnalysis
         *        a consumer that will call methods on {@link ContactAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactAnalysis(ContactAnalysis)
         */
        default Builder contactAnalysis(Consumer<ContactAnalysis.Builder> contactAnalysis) {
            return contactAnalysis(ContactAnalysis.builder().applyMutation(contactAnalysis).build());
        }

        /**
         * <p>
         * The list of initiation methods associated with contacts.
         * </p>
         * 
         * @param initiationMethods
         *        The list of initiation methods associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationMethodsWithStrings(Collection<String> initiationMethods);

        /**
         * <p>
         * The list of initiation methods associated with contacts.
         * </p>
         * 
         * @param initiationMethods
         *        The list of initiation methods associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationMethodsWithStrings(String... initiationMethods);

        /**
         * <p>
         * The list of initiation methods associated with contacts.
         * </p>
         * 
         * @param initiationMethods
         *        The list of initiation methods associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationMethods(Collection<ContactInitiationMethod> initiationMethods);

        /**
         * <p>
         * The list of initiation methods associated with contacts.
         * </p>
         * 
         * @param initiationMethods
         *        The list of initiation methods associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationMethods(ContactInitiationMethod... initiationMethods);

        /**
         * <p>
         * The list of queue IDs associated with contacts.
         * </p>
         * 
         * @param queueIds
         *        The list of queue IDs associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueIds(Collection<String> queueIds);

        /**
         * <p>
         * The list of queue IDs associated with contacts.
         * </p>
         * 
         * @param queueIds
         *        The list of queue IDs associated with contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueIds(String... queueIds);

        /**
         * <p>
         * The search criteria based on user-defined contact attributes that have been configured for contact search.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by custom
         * contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <important>
         * <p>
         * To use <code>SearchableContactAttributes</code> in a search request, the <code>GetContactAttributes</code>
         * action is required to perform an API request. For more information, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions"
         * >https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-
         * actions-as-permissions</a>Actions defined by Amazon Connect.
         * </p>
         * </important>
         * 
         * @param searchableContactAttributes
         *        The search criteria based on user-defined contact attributes that have been configured for contact
         *        search. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by
         *        custom contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <important>
         *        <p>
         *        To use <code>SearchableContactAttributes</code> in a search request, the
         *        <code>GetContactAttributes</code> action is required to perform an API request. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions"
         *        >https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#
         *        amazonconnect-actions-as-permissions</a>Actions defined by Amazon Connect.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchableContactAttributes(SearchableContactAttributes searchableContactAttributes);

        /**
         * <p>
         * The search criteria based on user-defined contact attributes that have been configured for contact search.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by custom
         * contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <important>
         * <p>
         * To use <code>SearchableContactAttributes</code> in a search request, the <code>GetContactAttributes</code>
         * action is required to perform an API request. For more information, see <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions"
         * >https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-
         * actions-as-permissions</a>Actions defined by Amazon Connect.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link SearchableContactAttributes.Builder} avoiding the need to create one manually via
         * {@link SearchableContactAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchableContactAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #searchableContactAttributes(SearchableContactAttributes)}.
         * 
         * @param searchableContactAttributes
         *        a consumer that will call methods on {@link SearchableContactAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchableContactAttributes(SearchableContactAttributes)
         */
        default Builder searchableContactAttributes(Consumer<SearchableContactAttributes.Builder> searchableContactAttributes) {
            return searchableContactAttributes(SearchableContactAttributes.builder().applyMutation(searchableContactAttributes)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();

        private AgentHierarchyGroups agentHierarchyGroups;

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private ContactAnalysis contactAnalysis;

        private List<String> initiationMethods = DefaultSdkAutoConstructList.getInstance();

        private List<String> queueIds = DefaultSdkAutoConstructList.getInstance();

        private SearchableContactAttributes searchableContactAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCriteria model) {
            agentIds(model.agentIds);
            agentHierarchyGroups(model.agentHierarchyGroups);
            channelsWithStrings(model.channels);
            contactAnalysis(model.contactAnalysis);
            initiationMethodsWithStrings(model.initiationMethods);
            queueIds(model.queueIds);
            searchableContactAttributes(model.searchableContactAttributes);
        }

        public final Collection<String> getAgentIds() {
            if (agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return agentIds;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String... agentIds) {
            agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final AgentHierarchyGroups.Builder getAgentHierarchyGroups() {
            return agentHierarchyGroups != null ? agentHierarchyGroups.toBuilder() : null;
        }

        public final void setAgentHierarchyGroups(AgentHierarchyGroups.BuilderImpl agentHierarchyGroups) {
            this.agentHierarchyGroups = agentHierarchyGroups != null ? agentHierarchyGroups.build() : null;
        }

        @Override
        public final Builder agentHierarchyGroups(AgentHierarchyGroups agentHierarchyGroups) {
            this.agentHierarchyGroups = agentHierarchyGroups;
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelListCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelListCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String... channels) {
            channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelListCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final ContactAnalysis.Builder getContactAnalysis() {
            return contactAnalysis != null ? contactAnalysis.toBuilder() : null;
        }

        public final void setContactAnalysis(ContactAnalysis.BuilderImpl contactAnalysis) {
            this.contactAnalysis = contactAnalysis != null ? contactAnalysis.build() : null;
        }

        @Override
        public final Builder contactAnalysis(ContactAnalysis contactAnalysis) {
            this.contactAnalysis = contactAnalysis;
            return this;
        }

        public final Collection<String> getInitiationMethods() {
            if (initiationMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return initiationMethods;
        }

        public final void setInitiationMethods(Collection<String> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copy(initiationMethods);
        }

        @Override
        public final Builder initiationMethodsWithStrings(Collection<String> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copy(initiationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiationMethodsWithStrings(String... initiationMethods) {
            initiationMethodsWithStrings(Arrays.asList(initiationMethods));
            return this;
        }

        @Override
        public final Builder initiationMethods(Collection<ContactInitiationMethod> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copyEnumToString(initiationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiationMethods(ContactInitiationMethod... initiationMethods) {
            initiationMethods(Arrays.asList(initiationMethods));
            return this;
        }

        public final Collection<String> getQueueIds() {
            if (queueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return queueIds;
        }

        public final void setQueueIds(Collection<String> queueIds) {
            this.queueIds = QueueIdListCopier.copy(queueIds);
        }

        @Override
        public final Builder queueIds(Collection<String> queueIds) {
            this.queueIds = QueueIdListCopier.copy(queueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueIds(String... queueIds) {
            queueIds(Arrays.asList(queueIds));
            return this;
        }

        public final SearchableContactAttributes.Builder getSearchableContactAttributes() {
            return searchableContactAttributes != null ? searchableContactAttributes.toBuilder() : null;
        }

        public final void setSearchableContactAttributes(SearchableContactAttributes.BuilderImpl searchableContactAttributes) {
            this.searchableContactAttributes = searchableContactAttributes != null ? searchableContactAttributes.build() : null;
        }

        @Override
        public final Builder searchableContactAttributes(SearchableContactAttributes searchableContactAttributes) {
            this.searchableContactAttributes = searchableContactAttributes;
            return this;
        }

        @Override
        public SearchCriteria build() {
            return new SearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
