/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Records configuration changes to your specified resource types. For more information about the configuration
 * recorder, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html">
 * <b>Managing the Configuration Recorder</b> </a> in the <i>Config Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationRecorder implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationRecorder.Builder, ConfigurationRecorder> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfigurationRecorder::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleARN").getter(getter(ConfigurationRecorder::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleARN").build()).build();

    private static final SdkField<RecordingGroup> RECORDING_GROUP_FIELD = SdkField
            .<RecordingGroup> builder(MarshallingType.SDK_POJO).memberName("recordingGroup")
            .getter(getter(ConfigurationRecorder::recordingGroup)).setter(setter(Builder::recordingGroup))
            .constructor(RecordingGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingGroup").build()).build();

    private static final SdkField<RecordingMode> RECORDING_MODE_FIELD = SdkField
            .<RecordingMode> builder(MarshallingType.SDK_POJO).memberName("recordingMode")
            .getter(getter(ConfigurationRecorder::recordingMode)).setter(setter(Builder::recordingMode))
            .constructor(RecordingMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            RECORDING_GROUP_FIELD, RECORDING_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String roleARN;

    private final RecordingGroup recordingGroup;

    private final RecordingMode recordingMode;

    private ConfigurationRecorder(BuilderImpl builder) {
        this.name = builder.name;
        this.roleARN = builder.roleARN;
        this.recordingGroup = builder.recordingGroup;
        this.recordingMode = builder.recordingMode;
    }

    /**
     * <p>
     * The name of the configuration recorder. Config automatically assigns the name of "default" when creating the
     * configuration recorder.
     * </p>
     * <note>
     * <p>
     * You cannot change the name of the configuration recorder after it has been created. To change the configuration
     * recorder name, you must delete it and create a new configuration recorder with a new name.
     * </p>
     * </note>
     * 
     * @return The name of the configuration recorder. Config automatically assigns the name of "default" when creating
     *         the configuration recorder.</p> <note>
     *         <p>
     *         You cannot change the name of the configuration recorder after it has been created. To change the
     *         configuration recorder name, you must delete it and create a new configuration recorder with a new name.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the configuration recorder.
     * </p>
     * <note>
     * <p>
     * While the API model does not require this field, the server will reject a request without a defined
     * <code>roleARN</code> for the configuration recorder.
     * </p>
     * </note> <note>
     * <p>
     * <b>Pre-existing Config role</b>
     * </p>
     * <p>
     * If you have used an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and an
     * Config role has already been created, make sure that the IAM role that you use when setting up Config keeps the
     * same minimum permissions as the already created Config role. You must do this so that the other Amazon Web
     * Services service continues to run as expected.
     * </p>
     * <p>
     * For example, if Control Tower has an IAM role that allows Config to read Amazon Simple Storage Service (Amazon
     * S3) objects, make sure that the same permissions are granted within the IAM role you use when setting up Config.
     * Otherwise, it may interfere with how Control Tower operates. For more information about IAM roles for Config, see
     * <a href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"> <b>Identity and Access
     * Management for Config</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the configuration recorder.</p>
     *         <note>
     *         <p>
     *         While the API model does not require this field, the server will reject a request without a defined
     *         <code>roleARN</code> for the configuration recorder.
     *         </p>
     *         </note> <note>
     *         <p>
     *         <b>Pre-existing Config role</b>
     *         </p>
     *         <p>
     *         If you have used an Amazon Web Services service that uses Config, such as Security Hub or Control Tower,
     *         and an Config role has already been created, make sure that the IAM role that you use when setting up
     *         Config keeps the same minimum permissions as the already created Config role. You must do this so that
     *         the other Amazon Web Services service continues to run as expected.
     *         </p>
     *         <p>
     *         For example, if Control Tower has an IAM role that allows Config to read Amazon Simple Storage Service
     *         (Amazon S3) objects, make sure that the same permissions are granted within the IAM role you use when
     *         setting up Config. Otherwise, it may interfere with how Control Tower operates. For more information
     *         about IAM roles for Config, see <a
     *         href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"> <b>Identity and Access
     *         Management for Config</b> </a> in the <i>Config Developer Guide</i>.
     *         </p>
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Specifies which resource types Config records for configuration changes.
     * </p>
     * <note>
     * <p>
     * <b> High Number of Config Evaluations</b>
     * </p>
     * <p>
     * You may notice increased activity in your account during your initial month recording with Config when compared
     * to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the resources in
     * your account that you have selected for Config to record.
     * </p>
     * <p>
     * If you are running ephemeral workloads, you may see increased activity from Config as it records configuration
     * changes associated with creating and deleting these temporary resources. An <i>ephemeral workload</i> is a
     * temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute
     * Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling. If you want to avoid the increased activity
     * from running ephemeral workloads, you can run these types of workloads in a separate account with Config turned
     * off to avoid increased configuration recording and rule evaluations.
     * </p>
     * </note>
     * 
     * @return Specifies which resource types Config records for configuration changes.</p> <note>
     *         <p>
     *         <b> High Number of Config Evaluations</b>
     *         </p>
     *         <p>
     *         You may notice increased activity in your account during your initial month recording with Config when
     *         compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all
     *         the resources in your account that you have selected for Config to record.
     *         </p>
     *         <p>
     *         If you are running ephemeral workloads, you may see increased activity from Config as it records
     *         configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral
     *         workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples
     *         include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling. If
     *         you want to avoid the increased activity from running ephemeral workloads, you can run these types of
     *         workloads in a separate account with Config turned off to avoid increased configuration recording and
     *         rule evaluations.
     *         </p>
     */
    public final RecordingGroup recordingGroup() {
        return recordingGroup;
    }

    /**
     * <p>
     * Specifies the default recording frequency that Config uses to record configuration changes. Config supports
     * <i>Continuous recording</i> and <i>Daily recording</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Continuous recording allows you to record configuration changes continuously whenever a change occurs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Daily recording allows you to receive a configuration item (CI) representing the most recent state of your
     * resources over the last 24-hour period, only if it’s different from the previous CI recorded.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it
     * is recommended that you set the recording frequency to Continuous.
     * </p>
     * </note>
     * <p>
     * You can also override the recording frequency for specific resource types.
     * </p>
     * 
     * @return Specifies the default recording frequency that Config uses to record configuration changes. Config
     *         supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Continuous recording allows you to record configuration changes continuously whenever a change occurs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Daily recording allows you to receive a configuration item (CI) representing the most recent state of
     *         your resources over the last 24-hour period, only if it’s different from the previous CI recorded.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall
     *         Manager, it is recommended that you set the recording frequency to Continuous.
     *         </p>
     *         </note>
     *         <p>
     *         You can also override the recording frequency for specific resource types.
     */
    public final RecordingMode recordingMode() {
        return recordingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(recordingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(recordingMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorder)) {
            return false;
        }
        ConfigurationRecorder other = (ConfigurationRecorder) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(recordingGroup(), other.recordingGroup())
                && Objects.equals(recordingMode(), other.recordingMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationRecorder").add("Name", name()).add("RoleARN", roleARN())
                .add("RecordingGroup", recordingGroup()).add("RecordingMode", recordingMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "recordingGroup":
            return Optional.ofNullable(clazz.cast(recordingGroup()));
        case "recordingMode":
            return Optional.ofNullable(clazz.cast(recordingMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorder, T> g) {
        return obj -> g.apply((ConfigurationRecorder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationRecorder> {
        /**
         * <p>
         * The name of the configuration recorder. Config automatically assigns the name of "default" when creating the
         * configuration recorder.
         * </p>
         * <note>
         * <p>
         * You cannot change the name of the configuration recorder after it has been created. To change the
         * configuration recorder name, you must delete it and create a new configuration recorder with a new name.
         * </p>
         * </note>
         * 
         * @param name
         *        The name of the configuration recorder. Config automatically assigns the name of "default" when
         *        creating the configuration recorder.</p> <note>
         *        <p>
         *        You cannot change the name of the configuration recorder after it has been created. To change the
         *        configuration recorder name, you must delete it and create a new configuration recorder with a new
         *        name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the configuration recorder.
         * </p>
         * <note>
         * <p>
         * While the API model does not require this field, the server will reject a request without a defined
         * <code>roleARN</code> for the configuration recorder.
         * </p>
         * </note> <note>
         * <p>
         * <b>Pre-existing Config role</b>
         * </p>
         * <p>
         * If you have used an Amazon Web Services service that uses Config, such as Security Hub or Control Tower, and
         * an Config role has already been created, make sure that the IAM role that you use when setting up Config
         * keeps the same minimum permissions as the already created Config role. You must do this so that the other
         * Amazon Web Services service continues to run as expected.
         * </p>
         * <p>
         * For example, if Control Tower has an IAM role that allows Config to read Amazon Simple Storage Service
         * (Amazon S3) objects, make sure that the same permissions are granted within the IAM role you use when setting
         * up Config. Otherwise, it may interfere with how Control Tower operates. For more information about IAM roles
         * for Config, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html">
         * <b>Identity and Access Management for Config</b> </a> in the <i>Config Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param roleARN
         *        Amazon Resource Name (ARN) of the IAM role assumed by Config and used by the configuration
         *        recorder.</p> <note>
         *        <p>
         *        While the API model does not require this field, the server will reject a request without a defined
         *        <code>roleARN</code> for the configuration recorder.
         *        </p>
         *        </note> <note>
         *        <p>
         *        <b>Pre-existing Config role</b>
         *        </p>
         *        <p>
         *        If you have used an Amazon Web Services service that uses Config, such as Security Hub or Control
         *        Tower, and an Config role has already been created, make sure that the IAM role that you use when
         *        setting up Config keeps the same minimum permissions as the already created Config role. You must do
         *        this so that the other Amazon Web Services service continues to run as expected.
         *        </p>
         *        <p>
         *        For example, if Control Tower has an IAM role that allows Config to read Amazon Simple Storage Service
         *        (Amazon S3) objects, make sure that the same permissions are granted within the IAM role you use when
         *        setting up Config. Otherwise, it may interfere with how Control Tower operates. For more information
         *        about IAM roles for Config, see <a
         *        href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"> <b>Identity and
         *        Access Management for Config</b> </a> in the <i>Config Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Specifies which resource types Config records for configuration changes.
         * </p>
         * <note>
         * <p>
         * <b> High Number of Config Evaluations</b>
         * </p>
         * <p>
         * You may notice increased activity in your account during your initial month recording with Config when
         * compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the
         * resources in your account that you have selected for Config to record.
         * </p>
         * <p>
         * If you are running ephemeral workloads, you may see increased activity from Config as it records
         * configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral
         * workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include
         * Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling. If you want to
         * avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a
         * separate account with Config turned off to avoid increased configuration recording and rule evaluations.
         * </p>
         * </note>
         * 
         * @param recordingGroup
         *        Specifies which resource types Config records for configuration changes.</p> <note>
         *        <p>
         *        <b> High Number of Config Evaluations</b>
         *        </p>
         *        <p>
         *        You may notice increased activity in your account during your initial month recording with Config when
         *        compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on
         *        all the resources in your account that you have selected for Config to record.
         *        </p>
         *        <p>
         *        If you are running ephemeral workloads, you may see increased activity from Config as it records
         *        configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral
         *        workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples
         *        include Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling.
         *        If you want to avoid the increased activity from running ephemeral workloads, you can run these types
         *        of workloads in a separate account with Config turned off to avoid increased configuration recording
         *        and rule evaluations.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingGroup(RecordingGroup recordingGroup);

        /**
         * <p>
         * Specifies which resource types Config records for configuration changes.
         * </p>
         * <note>
         * <p>
         * <b> High Number of Config Evaluations</b>
         * </p>
         * <p>
         * You may notice increased activity in your account during your initial month recording with Config when
         * compared to subsequent months. During the initial bootstrapping process, Config runs evaluations on all the
         * resources in your account that you have selected for Config to record.
         * </p>
         * <p>
         * If you are running ephemeral workloads, you may see increased activity from Config as it records
         * configuration changes associated with creating and deleting these temporary resources. An <i>ephemeral
         * workload</i> is a temporary use of computing resources that are loaded and run when needed. Examples include
         * Amazon Elastic Compute Cloud (Amazon EC2) Spot Instances, Amazon EMR jobs, and Auto Scaling. If you want to
         * avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a
         * separate account with Config turned off to avoid increased configuration recording and rule evaluations.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link RecordingGroup.Builder} avoiding
         * the need to create one manually via {@link RecordingGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordingGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #recordingGroup(RecordingGroup)}.
         * 
         * @param recordingGroup
         *        a consumer that will call methods on {@link RecordingGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingGroup(RecordingGroup)
         */
        default Builder recordingGroup(Consumer<RecordingGroup.Builder> recordingGroup) {
            return recordingGroup(RecordingGroup.builder().applyMutation(recordingGroup).build());
        }

        /**
         * <p>
         * Specifies the default recording frequency that Config uses to record configuration changes. Config supports
         * <i>Continuous recording</i> and <i>Daily recording</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Continuous recording allows you to record configuration changes continuously whenever a change occurs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Daily recording allows you to receive a configuration item (CI) representing the most recent state of your
         * resources over the last 24-hour period, only if it’s different from the previous CI recorded.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall
         * Manager, it is recommended that you set the recording frequency to Continuous.
         * </p>
         * </note>
         * <p>
         * You can also override the recording frequency for specific resource types.
         * </p>
         * 
         * @param recordingMode
         *        Specifies the default recording frequency that Config uses to record configuration changes. Config
         *        supports <i>Continuous recording</i> and <i>Daily recording</i>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Continuous recording allows you to record configuration changes continuously whenever a change occurs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Daily recording allows you to receive a configuration item (CI) representing the most recent state of
         *        your resources over the last 24-hour period, only if it’s different from the previous CI recorded.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall
         *        Manager, it is recommended that you set the recording frequency to Continuous.
         *        </p>
         *        </note>
         *        <p>
         *        You can also override the recording frequency for specific resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingMode(RecordingMode recordingMode);

        /**
         * <p>
         * Specifies the default recording frequency that Config uses to record configuration changes. Config supports
         * <i>Continuous recording</i> and <i>Daily recording</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Continuous recording allows you to record configuration changes continuously whenever a change occurs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Daily recording allows you to receive a configuration item (CI) representing the most recent state of your
         * resources over the last 24-hour period, only if it’s different from the previous CI recorded.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall
         * Manager, it is recommended that you set the recording frequency to Continuous.
         * </p>
         * </note>
         * <p>
         * You can also override the recording frequency for specific resource types.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordingMode.Builder} avoiding the need
         * to create one manually via {@link RecordingMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordingMode.Builder#build()} is called immediately and its
         * result is passed to {@link #recordingMode(RecordingMode)}.
         * 
         * @param recordingMode
         *        a consumer that will call methods on {@link RecordingMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingMode(RecordingMode)
         */
        default Builder recordingMode(Consumer<RecordingMode.Builder> recordingMode) {
            return recordingMode(RecordingMode.builder().applyMutation(recordingMode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String roleARN;

        private RecordingGroup recordingGroup;

        private RecordingMode recordingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorder model) {
            name(model.name);
            roleARN(model.roleARN);
            recordingGroup(model.recordingGroup);
            recordingMode(model.recordingMode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final RecordingGroup.Builder getRecordingGroup() {
            return recordingGroup != null ? recordingGroup.toBuilder() : null;
        }

        public final void setRecordingGroup(RecordingGroup.BuilderImpl recordingGroup) {
            this.recordingGroup = recordingGroup != null ? recordingGroup.build() : null;
        }

        @Override
        public final Builder recordingGroup(RecordingGroup recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        public final RecordingMode.Builder getRecordingMode() {
            return recordingMode != null ? recordingMode.toBuilder() : null;
        }

        public final void setRecordingMode(RecordingMode.BuilderImpl recordingMode) {
            this.recordingMode = recordingMode != null ? recordingMode.build() : null;
        }

        @Override
        public final Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        @Override
        public ConfigurationRecorder build() {
            return new ConfigurationRecorder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
