/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the effective recommendation preferences for Lambda functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaEffectiveRecommendationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaEffectiveRecommendationPreferences.Builder, LambdaEffectiveRecommendationPreferences> {
    private static final SdkField<LambdaSavingsEstimationMode> SAVINGS_ESTIMATION_MODE_FIELD = SdkField
            .<LambdaSavingsEstimationMode> builder(MarshallingType.SDK_POJO).memberName("savingsEstimationMode")
            .getter(getter(LambdaEffectiveRecommendationPreferences::savingsEstimationMode))
            .setter(setter(Builder::savingsEstimationMode)).constructor(LambdaSavingsEstimationMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SAVINGS_ESTIMATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaSavingsEstimationMode savingsEstimationMode;

    private LambdaEffectiveRecommendationPreferences(BuilderImpl builder) {
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    /**
     * <p>
     * Describes the savings estimation mode applied for calculating savings opportunity for Lambda functions.
     * </p>
     * 
     * @return Describes the savings estimation mode applied for calculating savings opportunity for Lambda functions.
     */
    public final LambdaSavingsEstimationMode savingsEstimationMode() {
        return savingsEstimationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsEstimationMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaEffectiveRecommendationPreferences)) {
            return false;
        }
        LambdaEffectiveRecommendationPreferences other = (LambdaEffectiveRecommendationPreferences) obj;
        return Objects.equals(savingsEstimationMode(), other.savingsEstimationMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaEffectiveRecommendationPreferences").add("SavingsEstimationMode", savingsEstimationMode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsEstimationMode":
            return Optional.ofNullable(clazz.cast(savingsEstimationMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaEffectiveRecommendationPreferences, T> g) {
        return obj -> g.apply((LambdaEffectiveRecommendationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaEffectiveRecommendationPreferences> {
        /**
         * <p>
         * Describes the savings estimation mode applied for calculating savings opportunity for Lambda functions.
         * </p>
         * 
         * @param savingsEstimationMode
         *        Describes the savings estimation mode applied for calculating savings opportunity for Lambda
         *        functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsEstimationMode(LambdaSavingsEstimationMode savingsEstimationMode);

        /**
         * <p>
         * Describes the savings estimation mode applied for calculating savings opportunity for Lambda functions.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaSavingsEstimationMode.Builder}
         * avoiding the need to create one manually via {@link LambdaSavingsEstimationMode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaSavingsEstimationMode.Builder#build()} is called
         * immediately and its result is passed to {@link #savingsEstimationMode(LambdaSavingsEstimationMode)}.
         * 
         * @param savingsEstimationMode
         *        a consumer that will call methods on {@link LambdaSavingsEstimationMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsEstimationMode(LambdaSavingsEstimationMode)
         */
        default Builder savingsEstimationMode(Consumer<LambdaSavingsEstimationMode.Builder> savingsEstimationMode) {
            return savingsEstimationMode(LambdaSavingsEstimationMode.builder().applyMutation(savingsEstimationMode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaSavingsEstimationMode savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaEffectiveRecommendationPreferences model) {
            savingsEstimationMode(model.savingsEstimationMode);
        }

        public final LambdaSavingsEstimationMode.Builder getSavingsEstimationMode() {
            return savingsEstimationMode != null ? savingsEstimationMode.toBuilder() : null;
        }

        public final void setSavingsEstimationMode(LambdaSavingsEstimationMode.BuilderImpl savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode != null ? savingsEstimationMode.build() : null;
        }

        @Override
        public final Builder savingsEstimationMode(LambdaSavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        @Override
        public LambdaEffectiveRecommendationPreferences build() {
            return new LambdaEffectiveRecommendationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
