/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the savings estimation mode used for calculating savings opportunity for Amazon EBS volumes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EBSSavingsEstimationMode implements SdkPojo, Serializable,
        ToCopyableBuilder<EBSSavingsEstimationMode.Builder, EBSSavingsEstimationMode> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(EBSSavingsEstimationMode::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private EBSSavingsEstimationMode(BuilderImpl builder) {
        this.source = builder.source;
    }

    /**
     * <p>
     * Describes the source for calculating the savings opportunity for Amazon EBS volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link EBSSavingsEstimationModeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceAsString}.
     * </p>
     * 
     * @return Describes the source for calculating the savings opportunity for Amazon EBS volumes.
     * @see EBSSavingsEstimationModeSource
     */
    public final EBSSavingsEstimationModeSource source() {
        return EBSSavingsEstimationModeSource.fromValue(source);
    }

    /**
     * <p>
     * Describes the source for calculating the savings opportunity for Amazon EBS volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link EBSSavingsEstimationModeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceAsString}.
     * </p>
     * 
     * @return Describes the source for calculating the savings opportunity for Amazon EBS volumes.
     * @see EBSSavingsEstimationModeSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSSavingsEstimationMode)) {
            return false;
        }
        EBSSavingsEstimationMode other = (EBSSavingsEstimationMode) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EBSSavingsEstimationMode").add("Source", sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EBSSavingsEstimationMode, T> g) {
        return obj -> g.apply((EBSSavingsEstimationMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EBSSavingsEstimationMode> {
        /**
         * <p>
         * Describes the source for calculating the savings opportunity for Amazon EBS volumes.
         * </p>
         * 
         * @param source
         *        Describes the source for calculating the savings opportunity for Amazon EBS volumes.
         * @see EBSSavingsEstimationModeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EBSSavingsEstimationModeSource
         */
        Builder source(String source);

        /**
         * <p>
         * Describes the source for calculating the savings opportunity for Amazon EBS volumes.
         * </p>
         * 
         * @param source
         *        Describes the source for calculating the savings opportunity for Amazon EBS volumes.
         * @see EBSSavingsEstimationModeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EBSSavingsEstimationModeSource
         */
        Builder source(EBSSavingsEstimationModeSource source);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSSavingsEstimationMode model) {
            source(model.source);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(EBSSavingsEstimationModeSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public EBSSavingsEstimationMode build() {
            return new EBSSavingsEstimationMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
