/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the recommended RDS storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DBStorageConfiguration.Builder, DBStorageConfiguration> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(DBStorageConfiguration::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("allocatedStorage").getter(getter(DBStorageConfiguration::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("iops")
            .getter(getter(DBStorageConfiguration::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()).build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxAllocatedStorage").getter(getter(DBStorageConfiguration::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAllocatedStorage").build())
            .build();

    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageThroughput").getter(getter(DBStorageConfiguration::storageThroughput))
            .setter(setter(Builder::storageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            ALLOCATED_STORAGE_FIELD, IOPS_FIELD, MAX_ALLOCATED_STORAGE_FIELD, STORAGE_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String storageType;

    private final Integer allocatedStorage;

    private final Integer iops;

    private final Integer maxAllocatedStorage;

    private final Integer storageThroughput;

    private DBStorageConfiguration(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.iops = builder.iops;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.storageThroughput = builder.storageThroughput;
    }

    /**
     * <p>
     * The type of RDS storage.
     * </p>
     * 
     * @return The type of RDS storage.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The size of the RDS storage in gigabytes (GB).
     * </p>
     * 
     * @return The size of the RDS storage in gigabytes (GB).
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The provisioned IOPs of the RDS storage.
     * </p>
     * 
     * @return The provisioned IOPs of the RDS storage.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the RDS instance.
     * </p>
     * 
     * @return The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the RDS
     *         instance.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    /**
     * <p>
     * The storage throughput of the RDS storage.
     * </p>
     * 
     * @return The storage throughput of the RDS storage.
     */
    public final Integer storageThroughput() {
        return storageThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(storageThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBStorageConfiguration)) {
            return false;
        }
        DBStorageConfiguration other = (DBStorageConfiguration) obj;
        return Objects.equals(storageType(), other.storageType()) && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(iops(), other.iops()) && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage())
                && Objects.equals(storageThroughput(), other.storageThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBStorageConfiguration").add("StorageType", storageType())
                .add("AllocatedStorage", allocatedStorage()).add("Iops", iops())
                .add("MaxAllocatedStorage", maxAllocatedStorage()).add("StorageThroughput", storageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "allocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "maxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        case "storageThroughput":
            return Optional.ofNullable(clazz.cast(storageThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBStorageConfiguration, T> g) {
        return obj -> g.apply((DBStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBStorageConfiguration> {
        /**
         * <p>
         * The type of RDS storage.
         * </p>
         * 
         * @param storageType
         *        The type of RDS storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The size of the RDS storage in gigabytes (GB).
         * </p>
         * 
         * @param allocatedStorage
         *        The size of the RDS storage in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The provisioned IOPs of the RDS storage.
         * </p>
         * 
         * @param iops
         *        The provisioned IOPs of the RDS storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the RDS
         * instance.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the
         *        RDS instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);

        /**
         * <p>
         * The storage throughput of the RDS storage.
         * </p>
         * 
         * @param storageThroughput
         *        The storage throughput of the RDS storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageThroughput(Integer storageThroughput);
    }

    static final class BuilderImpl implements Builder {
        private String storageType;

        private Integer allocatedStorage;

        private Integer iops;

        private Integer maxAllocatedStorage;

        private Integer storageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(DBStorageConfiguration model) {
            storageType(model.storageType);
            allocatedStorage(model.allocatedStorage);
            iops(model.iops);
            maxAllocatedStorage(model.maxAllocatedStorage);
            storageThroughput(model.storageThroughput);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Integer getStorageThroughput() {
            return storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        @Override
        public DBStorageConfiguration build() {
            return new DBStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
