/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * User pool add-ons. Contains settings for activation of advanced security features. To log user security information
 * but take no action, set to <code>AUDIT</code>. To configure automatic security responses to risky traffic to your
 * user pool, set to <code>ENFORCED</code>.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html"
 * >Adding advanced security to a user pool</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPoolAddOnsType implements SdkPojo, Serializable,
        ToCopyableBuilder<UserPoolAddOnsType.Builder, UserPoolAddOnsType> {
    private static final SdkField<String> ADVANCED_SECURITY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdvancedSecurityMode").getter(getter(UserPoolAddOnsType::advancedSecurityModeAsString))
            .setter(setter(Builder::advancedSecurityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADVANCED_SECURITY_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String advancedSecurityMode;

    private UserPoolAddOnsType(BuilderImpl builder) {
        this.advancedSecurityMode = builder.advancedSecurityMode;
    }

    /**
     * <p>
     * The operating mode of advanced security features in your user pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #advancedSecurityMode} will return {@link AdvancedSecurityModeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #advancedSecurityModeAsString}.
     * </p>
     * 
     * @return The operating mode of advanced security features in your user pool.
     * @see AdvancedSecurityModeType
     */
    public final AdvancedSecurityModeType advancedSecurityMode() {
        return AdvancedSecurityModeType.fromValue(advancedSecurityMode);
    }

    /**
     * <p>
     * The operating mode of advanced security features in your user pool.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #advancedSecurityMode} will return {@link AdvancedSecurityModeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #advancedSecurityModeAsString}.
     * </p>
     * 
     * @return The operating mode of advanced security features in your user pool.
     * @see AdvancedSecurityModeType
     */
    public final String advancedSecurityModeAsString() {
        return advancedSecurityMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolAddOnsType)) {
            return false;
        }
        UserPoolAddOnsType other = (UserPoolAddOnsType) obj;
        return Objects.equals(advancedSecurityModeAsString(), other.advancedSecurityModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPoolAddOnsType").add("AdvancedSecurityMode", advancedSecurityModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdvancedSecurityMode":
            return Optional.ofNullable(clazz.cast(advancedSecurityModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolAddOnsType, T> g) {
        return obj -> g.apply((UserPoolAddOnsType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPoolAddOnsType> {
        /**
         * <p>
         * The operating mode of advanced security features in your user pool.
         * </p>
         * 
         * @param advancedSecurityMode
         *        The operating mode of advanced security features in your user pool.
         * @see AdvancedSecurityModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedSecurityModeType
         */
        Builder advancedSecurityMode(String advancedSecurityMode);

        /**
         * <p>
         * The operating mode of advanced security features in your user pool.
         * </p>
         * 
         * @param advancedSecurityMode
         *        The operating mode of advanced security features in your user pool.
         * @see AdvancedSecurityModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdvancedSecurityModeType
         */
        Builder advancedSecurityMode(AdvancedSecurityModeType advancedSecurityMode);
    }

    static final class BuilderImpl implements Builder {
        private String advancedSecurityMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolAddOnsType model) {
            advancedSecurityMode(model.advancedSecurityMode);
        }

        public final String getAdvancedSecurityMode() {
            return advancedSecurityMode;
        }

        public final void setAdvancedSecurityMode(String advancedSecurityMode) {
            this.advancedSecurityMode = advancedSecurityMode;
        }

        @Override
        public final Builder advancedSecurityMode(String advancedSecurityMode) {
            this.advancedSecurityMode = advancedSecurityMode;
            return this;
        }

        @Override
        public final Builder advancedSecurityMode(AdvancedSecurityModeType advancedSecurityMode) {
            this.advancedSecurityMode(advancedSecurityMode == null ? null : advancedSecurityMode.toString());
            return this;
        }

        @Override
        public UserPoolAddOnsType build() {
            return new UserPoolAddOnsType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
