/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAuthEventFeedbackRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<UpdateAuthEventFeedbackRequest.Builder, UpdateAuthEventFeedbackRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(UpdateAuthEventFeedbackRequest::userPoolId))
            .setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UpdateAuthEventFeedbackRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(UpdateAuthEventFeedbackRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> FEEDBACK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackToken").getter(getter(UpdateAuthEventFeedbackRequest::feedbackToken))
            .setter(setter(Builder::feedbackToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackToken").build()).build();

    private static final SdkField<String> FEEDBACK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackValue").getter(getter(UpdateAuthEventFeedbackRequest::feedbackValueAsString))
            .setter(setter(Builder::feedbackValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD,
            USERNAME_FIELD, EVENT_ID_FIELD, FEEDBACK_TOKEN_FIELD, FEEDBACK_VALUE_FIELD));

    private final String userPoolId;

    private final String username;

    private final String eventId;

    private final String feedbackToken;

    private final String feedbackValue;

    private UpdateAuthEventFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.eventId = builder.eventId;
        this.feedbackToken = builder.feedbackToken;
        this.feedbackValue = builder.feedbackValue;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The username of the user that you want to query or modify. The value of this parameter is typically your user's
     * username, but it can be any of their alias attributes. If <code>username</code> isn't an alias attribute in your
     * user pool, this value must be the <code>sub</code> of a local user or the username of a user from a third-party
     * IdP.
     * </p>
     * 
     * @return The username of the user that you want to query or modify. The value of this parameter is typically your
     *         user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
     *         attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
     *         user from a third-party IdP.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The feedback token.
     * </p>
     * 
     * @return The feedback token.
     */
    public final String feedbackToken() {
        return feedbackToken;
    }

    /**
     * <p>
     * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some
     * level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon
     * Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a high-enough
     * risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     *         <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
     *         evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>
     *         , you tell Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito
     *         evaluated a high-enough risk level.
     * @see FeedbackValueType
     */
    public final FeedbackValueType feedbackValue() {
        return FeedbackValueType.fromValue(feedbackValue);
    }

    /**
     * <p>
     * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated some
     * level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell Amazon
     * Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a high-enough
     * risk level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedbackValue}
     * will return {@link FeedbackValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #feedbackValueAsString}.
     * </p>
     * 
     * @return The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
     *         <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
     *         evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>
     *         , you tell Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito
     *         evaluated a high-enough risk level.
     * @see FeedbackValueType
     */
    public final String feedbackValueAsString() {
        return feedbackValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackValueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthEventFeedbackRequest)) {
            return false;
        }
        UpdateAuthEventFeedbackRequest other = (UpdateAuthEventFeedbackRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(username(), other.username())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(feedbackToken(), other.feedbackToken())
                && Objects.equals(feedbackValueAsString(), other.feedbackValueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAuthEventFeedbackRequest").add("UserPoolId", userPoolId())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").add("EventId", eventId())
                .add("FeedbackToken", feedbackToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FeedbackValue", feedbackValueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "FeedbackToken":
            return Optional.ofNullable(clazz.cast(feedbackToken()));
        case "FeedbackValue":
            return Optional.ofNullable(clazz.cast(feedbackValueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthEventFeedbackRequest, T> g) {
        return obj -> g.apply((UpdateAuthEventFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAuthEventFeedbackRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The username of the user that you want to query or modify. The value of this parameter is typically your
         * user's username, but it can be any of their alias attributes. If <code>username</code> isn't an alias
         * attribute in your user pool, this value must be the <code>sub</code> of a local user or the username of a
         * user from a third-party IdP.
         * </p>
         * 
         * @param username
         *        The username of the user that you want to query or modify. The value of this parameter is typically
         *        your user's username, but it can be any of their alias attributes. If <code>username</code> isn't an
         *        alias attribute in your user pool, this value must be the <code>sub</code> of a local user or the
         *        username of a user from a third-party IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The feedback token.
         * </p>
         * 
         * @param feedbackToken
         *        The feedback token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackToken(String feedbackToken);

        /**
         * <p>
         * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated
         * some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell
         * Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a
         * high-enough risk level.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         *        <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
         *        evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of
         *        <code>invalid</code>, you tell Amazon Cognito that you don't trust a user session, or you don't
         *        believe that Amazon Cognito evaluated a high-enough risk level.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(String feedbackValue);

        /**
         * <p>
         * The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         * <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has evaluated
         * some level of risk. When you provide a <code>FeedbackValue</code> value of <code>invalid</code>, you tell
         * Amazon Cognito that you don't trust a user session, or you don't believe that Amazon Cognito evaluated a
         * high-enough risk level.
         * </p>
         * 
         * @param feedbackValue
         *        The authentication event feedback value. When you provide a <code>FeedbackValue</code> value of
         *        <code>valid</code>, you tell Amazon Cognito that you trust a user session where Amazon Cognito has
         *        evaluated some level of risk. When you provide a <code>FeedbackValue</code> value of
         *        <code>invalid</code>, you tell Amazon Cognito that you don't trust a user session, or you don't
         *        believe that Amazon Cognito evaluated a high-enough risk level.
         * @see FeedbackValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeedbackValueType
         */
        Builder feedbackValue(FeedbackValueType feedbackValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String username;

        private String eventId;

        private String feedbackToken;

        private String feedbackValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthEventFeedbackRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            username(model.username);
            eventId(model.eventId);
            feedbackToken(model.feedbackToken);
            feedbackValue(model.feedbackValue);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getFeedbackToken() {
            return feedbackToken;
        }

        public final void setFeedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
        }

        @Override
        public final Builder feedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
            return this;
        }

        public final String getFeedbackValue() {
            return feedbackValue;
        }

        public final void setFeedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
        }

        @Override
        public final Builder feedbackValue(String feedbackValue) {
            this.feedbackValue = feedbackValue;
            return this;
        }

        @Override
        public final Builder feedbackValue(FeedbackValueType feedbackValue) {
            this.feedbackValue(feedbackValue == null ? null : feedbackValue.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuthEventFeedbackRequest build() {
            return new UpdateAuthEventFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
