/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.RegistrationStatus;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOnPremisesInstancesRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationStatus").getter(ListOnPremisesInstancesRequest.getter(ListOnPremisesInstancesRequest::registrationStatusAsString)).setter(ListOnPremisesInstancesRequest.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagFilters").getter(ListOnPremisesInstancesRequest.getter(ListOnPremisesInstancesRequest::tagFilters)).setter(ListOnPremisesInstancesRequest.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOnPremisesInstancesRequest.getter(ListOnPremisesInstancesRequest::nextToken)).setter(ListOnPremisesInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_STATUS_FIELD, TAG_FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOnPremisesInstancesRequest.memberNameToFieldInitializer();
    private final String registrationStatus;
    private final List<TagFilter> tagFilters;
    private final String nextToken;

    private ListOnPremisesInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.registrationStatus = builder.registrationStatus;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final boolean hasTagFilters() {
        return this.tagFilters != null && !(this.tagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagFilters() ? this.tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesRequest)) {
            return false;
        }
        ListOnPremisesInstancesRequest other = (ListOnPremisesInstancesRequest)((Object)obj);
        return Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && this.hasTagFilters() == other.hasTagFilters() && Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOnPremisesInstancesRequest").add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("TagFilters", this.hasTagFilters() ? this.tagFilters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "tagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registrationStatus", REGISTRATION_STATUS_FIELD);
        map.put("tagFilters", TAG_FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOnPremisesInstancesRequest, T> g) {
        return obj -> g.apply((ListOnPremisesInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String registrationStatus;
        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesRequest model) {
            super(model);
            this.registrationStatus(model.registrationStatus);
            this.tagFilters(model.tagFilters);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOnPremisesInstancesRequest build() {
            return new ListOnPremisesInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder tagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

