/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LifecycleErrorCode {
    SUCCESS("Success"),
    SCRIPT_MISSING("ScriptMissing"),
    SCRIPT_NOT_EXECUTABLE("ScriptNotExecutable"),
    SCRIPT_TIMED_OUT("ScriptTimedOut"),
    SCRIPT_FAILED("ScriptFailed"),
    UNKNOWN_ERROR("UnknownError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifecycleErrorCode> VALUE_MAP;
    private final String value;

    private LifecycleErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifecycleErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifecycleErrorCode> knownValues() {
        EnumSet<LifecycleErrorCode> knownValues = EnumSet.allOf(LifecycleErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LifecycleErrorCode.class, LifecycleErrorCode::toString);
    }
}

