/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that define or describe the historical data that your auto-adjusting budget is based on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoricalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<HistoricalOptions.Builder, HistoricalOptions> {
    private static final SdkField<Integer> BUDGET_ADJUSTMENT_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BudgetAdjustmentPeriod").getter(getter(HistoricalOptions::budgetAdjustmentPeriod))
            .setter(setter(Builder::budgetAdjustmentPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetAdjustmentPeriod").build())
            .build();

    private static final SdkField<Integer> LOOK_BACK_AVAILABLE_PERIODS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("LookBackAvailablePeriods")
            .getter(getter(HistoricalOptions::lookBackAvailablePeriods)).setter(setter(Builder::lookBackAvailablePeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackAvailablePeriods").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUDGET_ADJUSTMENT_PERIOD_FIELD, LOOK_BACK_AVAILABLE_PERIODS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer budgetAdjustmentPeriod;

    private final Integer lookBackAvailablePeriods;

    private HistoricalOptions(BuilderImpl builder) {
        this.budgetAdjustmentPeriod = builder.budgetAdjustmentPeriod;
        this.lookBackAvailablePeriods = builder.lookBackAvailablePeriods;
    }

    /**
     * <p>
     * The number of budget periods included in the moving-average calculation that determines your auto-adjusted budget
     * amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of budget periods included in the moving-average calculation that determines your
     *         auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the
     *         budget:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.
     *         </p>
     *         </li>
     */
    public final Integer budgetAdjustmentPeriod() {
        return budgetAdjustmentPeriod;
    }

    /**
     * <p>
     * The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included in
     * the calculation of your current <code>BudgetLimit</code>. If the first budget period in your
     * <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average that
     * determines your budget limit.
     * </p>
     * <p>
     * For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had no
     * cost data in the first quarter, then only the last three quarters are included in the calculation. In this
     * scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>.
     * </p>
     * <p>
     * You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the
     * <code>BudgetAdjustmentPeriod</code> and your historical cost data.
     * </p>
     * 
     * @return The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are
     *         included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your
     *         <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the
     *         average that determines your budget limit. </p>
     *         <p>
     *         For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account
     *         had no cost data in the first quarter, then only the last three quarters are included in the calculation.
     *         In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>.
     *         </p>
     *         <p>
     *         You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from
     *         the <code>BudgetAdjustmentPeriod</code> and your historical cost data.
     */
    public final Integer lookBackAvailablePeriods() {
        return lookBackAvailablePeriods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budgetAdjustmentPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(lookBackAvailablePeriods());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalOptions)) {
            return false;
        }
        HistoricalOptions other = (HistoricalOptions) obj;
        return Objects.equals(budgetAdjustmentPeriod(), other.budgetAdjustmentPeriod())
                && Objects.equals(lookBackAvailablePeriods(), other.lookBackAvailablePeriods());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistoricalOptions").add("BudgetAdjustmentPeriod", budgetAdjustmentPeriod())
                .add("LookBackAvailablePeriods", lookBackAvailablePeriods()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetAdjustmentPeriod":
            return Optional.ofNullable(clazz.cast(budgetAdjustmentPeriod()));
        case "LookBackAvailablePeriods":
            return Optional.ofNullable(clazz.cast(lookBackAvailablePeriods()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalOptions, T> g) {
        return obj -> g.apply((HistoricalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoricalOptions> {
        /**
         * <p>
         * The number of budget periods included in the moving-average calculation that determines your auto-adjusted
         * budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the budget:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param budgetAdjustmentPeriod
         *        The number of budget periods included in the moving-average calculation that determines your
         *        auto-adjusted budget amount. The maximum value depends on the <code>TimeUnit</code> granularity of the
         *        budget:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>DAILY</code> granularity, the maximum value is <code>60</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>MONTHLY</code> granularity, the maximum value is <code>12</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>QUARTERLY</code> granularity, the maximum value is <code>4</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>ANNUALLY</code> granularity, the maximum value is <code>1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetAdjustmentPeriod(Integer budgetAdjustmentPeriod);

        /**
         * <p>
         * The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are included
         * in the calculation of your current <code>BudgetLimit</code>. If the first budget period in your
         * <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in the average
         * that determines your budget limit.
         * </p>
         * <p>
         * For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your account had
         * no cost data in the first quarter, then only the last three quarters are included in the calculation. In this
         * scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>.
         * </p>
         * <p>
         * You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated from the
         * <code>BudgetAdjustmentPeriod</code> and your historical cost data.
         * </p>
         * 
         * @param lookBackAvailablePeriods
         *        The integer that describes how many budget periods in your <code>BudgetAdjustmentPeriod</code> are
         *        included in the calculation of your current <code>BudgetLimit</code>. If the first budget period in
         *        your <code>BudgetAdjustmentPeriod</code> has no cost data, then that budget period isn’t included in
         *        the average that determines your budget limit. </p>
         *        <p>
         *        For example, if you set <code>BudgetAdjustmentPeriod</code> as <code>4</code> quarters, but your
         *        account had no cost data in the first quarter, then only the last three quarters are included in the
         *        calculation. In this scenario, <code>LookBackAvailablePeriods</code> returns <code>3</code>.
         *        </p>
         *        <p>
         *        You can’t set your own <code>LookBackAvailablePeriods</code>. The value is automatically calculated
         *        from the <code>BudgetAdjustmentPeriod</code> and your historical cost data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookBackAvailablePeriods(Integer lookBackAvailablePeriods);
    }

    static final class BuilderImpl implements Builder {
        private Integer budgetAdjustmentPeriod;

        private Integer lookBackAvailablePeriods;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalOptions model) {
            budgetAdjustmentPeriod(model.budgetAdjustmentPeriod);
            lookBackAvailablePeriods(model.lookBackAvailablePeriods);
        }

        public final Integer getBudgetAdjustmentPeriod() {
            return budgetAdjustmentPeriod;
        }

        public final void setBudgetAdjustmentPeriod(Integer budgetAdjustmentPeriod) {
            this.budgetAdjustmentPeriod = budgetAdjustmentPeriod;
        }

        @Override
        public final Builder budgetAdjustmentPeriod(Integer budgetAdjustmentPeriod) {
            this.budgetAdjustmentPeriod = budgetAdjustmentPeriod;
            return this;
        }

        public final Integer getLookBackAvailablePeriods() {
            return lookBackAvailablePeriods;
        }

        public final void setLookBackAvailablePeriods(Integer lookBackAvailablePeriods) {
            this.lookBackAvailablePeriods = lookBackAvailablePeriods;
        }

        @Override
        public final Builder lookBackAvailablePeriods(Integer lookBackAvailablePeriods) {
            this.lookBackAvailablePeriods = lookBackAvailablePeriods;
            return this;
        }

        @Override
        public HistoricalOptions build() {
            return new HistoricalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
