/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptSessionAttributesMapCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.ReturnControlInvocationResultsCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.SessionAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionState> {
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationId").getter(SessionState.getter(SessionState::invocationId)).setter(SessionState.setter(Builder::invocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()}).build();
    private static final SdkField<Map<String, String>> PROMPT_SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("promptSessionAttributes").getter(SessionState.getter(SessionState::promptSessionAttributes)).setter(SessionState.setter(Builder::promptSessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InvocationResultMember>> RETURN_CONTROL_INVOCATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("returnControlInvocationResults").getter(SessionState.getter(SessionState::returnControlInvocationResults)).setter(SessionState.setter(Builder::returnControlInvocationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlInvocationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvocationResultMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(SessionState.getter(SessionState::sessionAttributes)).setter(SessionState.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ID_FIELD, PROMPT_SESSION_ATTRIBUTES_FIELD, RETURN_CONTROL_INVOCATION_RESULTS_FIELD, SESSION_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String invocationId;
    private final Map<String, String> promptSessionAttributes;
    private final List<InvocationResultMember> returnControlInvocationResults;
    private final Map<String, String> sessionAttributes;

    private SessionState(BuilderImpl builder) {
        this.invocationId = builder.invocationId;
        this.promptSessionAttributes = builder.promptSessionAttributes;
        this.returnControlInvocationResults = builder.returnControlInvocationResults;
        this.sessionAttributes = builder.sessionAttributes;
    }

    public final String invocationId() {
        return this.invocationId;
    }

    public final boolean hasPromptSessionAttributes() {
        return this.promptSessionAttributes != null && !(this.promptSessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> promptSessionAttributes() {
        return this.promptSessionAttributes;
    }

    public final boolean hasReturnControlInvocationResults() {
        return this.returnControlInvocationResults != null && !(this.returnControlInvocationResults instanceof SdkAutoConstructList);
    }

    public final List<InvocationResultMember> returnControlInvocationResults() {
        return this.returnControlInvocationResults;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptSessionAttributes() ? this.promptSessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReturnControlInvocationResults() ? this.returnControlInvocationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState)obj;
        return Objects.equals(this.invocationId(), other.invocationId()) && this.hasPromptSessionAttributes() == other.hasPromptSessionAttributes() && Objects.equals(this.promptSessionAttributes(), other.promptSessionAttributes()) && this.hasReturnControlInvocationResults() == other.hasReturnControlInvocationResults() && Objects.equals(this.returnControlInvocationResults(), other.returnControlInvocationResults()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"SessionState").add("InvocationId", (Object)this.invocationId()).add("PromptSessionAttributes", this.hasPromptSessionAttributes() ? this.promptSessionAttributes() : null).add("ReturnControlInvocationResults", this.hasReturnControlInvocationResults() ? this.returnControlInvocationResults() : null).add("SessionAttributes", this.hasSessionAttributes() ? this.sessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationId": {
                return Optional.ofNullable(clazz.cast(this.invocationId()));
            }
            case "promptSessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.promptSessionAttributes()));
            }
            case "returnControlInvocationResults": {
                return Optional.ofNullable(clazz.cast(this.returnControlInvocationResults()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionState, T> g) {
        return obj -> g.apply((SessionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invocationId;
        private Map<String, String> promptSessionAttributes = DefaultSdkAutoConstructMap.getInstance();
        private List<InvocationResultMember> returnControlInvocationResults = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SessionState model) {
            this.invocationId(model.invocationId);
            this.promptSessionAttributes(model.promptSessionAttributes);
            this.returnControlInvocationResults(model.returnControlInvocationResults);
            this.sessionAttributes(model.sessionAttributes);
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final Map<String, String> getPromptSessionAttributes() {
            if (this.promptSessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.promptSessionAttributes;
        }

        public final void setPromptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
        }

        @Override
        public final Builder promptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
            return this;
        }

        public final List<InvocationResultMember.Builder> getReturnControlInvocationResults() {
            List<InvocationResultMember.Builder> result = ReturnControlInvocationResultsCopier.copyToBuilder(this.returnControlInvocationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnControlInvocationResults(Collection<InvocationResultMember.BuilderImpl> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copyFromBuilder(returnControlInvocationResults);
        }

        @Override
        public final Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copy(returnControlInvocationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(InvocationResultMember ... returnControlInvocationResults) {
            this.returnControlInvocationResults(Arrays.asList(returnControlInvocationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder> ... returnControlInvocationResults) {
            this.returnControlInvocationResults(Stream.of(returnControlInvocationResults).map(c -> (InvocationResultMember)((InvocationResultMember.Builder)InvocationResultMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
            return this;
        }

        public SessionState build() {
            return new SessionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionState> {
        public Builder invocationId(String var1);

        public Builder promptSessionAttributes(Map<String, String> var1);

        public Builder returnControlInvocationResults(Collection<InvocationResultMember> var1);

        public Builder returnControlInvocationResults(InvocationResultMember ... var1);

        public Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder> ... var1);

        public Builder sessionAttributes(Map<String, String> var1);
    }
}

