/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksContainerSecurityContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksContainerSecurityContext> {
    private static final SdkField<Long> RUN_AS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("runAsUser").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::runAsUser)).setter(EksContainerSecurityContext.setter(Builder::runAsUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsUser").build()}).build();
    private static final SdkField<Long> RUN_AS_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("runAsGroup").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::runAsGroup)).setter(EksContainerSecurityContext.setter(Builder::runAsGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsGroup").build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privileged").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::privileged)).setter(EksContainerSecurityContext.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()}).build();
    private static final SdkField<Boolean> ALLOW_PRIVILEGE_ESCALATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowPrivilegeEscalation").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::allowPrivilegeEscalation)).setter(EksContainerSecurityContext.setter(Builder::allowPrivilegeEscalation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowPrivilegeEscalation").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_ROOT_FILESYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readOnlyRootFilesystem").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::readOnlyRootFilesystem)).setter(EksContainerSecurityContext.setter(Builder::readOnlyRootFilesystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyRootFilesystem").build()}).build();
    private static final SdkField<Boolean> RUN_AS_NON_ROOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runAsNonRoot").getter(EksContainerSecurityContext.getter(EksContainerSecurityContext::runAsNonRoot)).setter(EksContainerSecurityContext.setter(Builder::runAsNonRoot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsNonRoot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_AS_USER_FIELD, RUN_AS_GROUP_FIELD, PRIVILEGED_FIELD, ALLOW_PRIVILEGE_ESCALATION_FIELD, READ_ONLY_ROOT_FILESYSTEM_FIELD, RUN_AS_NON_ROOT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long runAsUser;
    private final Long runAsGroup;
    private final Boolean privileged;
    private final Boolean allowPrivilegeEscalation;
    private final Boolean readOnlyRootFilesystem;
    private final Boolean runAsNonRoot;

    private EksContainerSecurityContext(BuilderImpl builder) {
        this.runAsUser = builder.runAsUser;
        this.runAsGroup = builder.runAsGroup;
        this.privileged = builder.privileged;
        this.allowPrivilegeEscalation = builder.allowPrivilegeEscalation;
        this.readOnlyRootFilesystem = builder.readOnlyRootFilesystem;
        this.runAsNonRoot = builder.runAsNonRoot;
    }

    public final Long runAsUser() {
        return this.runAsUser;
    }

    public final Long runAsGroup() {
        return this.runAsGroup;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public final Boolean allowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public final Boolean readOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public final Boolean runAsNonRoot() {
        return this.runAsNonRoot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.runAsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowPrivilegeEscalation());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.runAsNonRoot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerSecurityContext)) {
            return false;
        }
        EksContainerSecurityContext other = (EksContainerSecurityContext)obj;
        return Objects.equals(this.runAsUser(), other.runAsUser()) && Objects.equals(this.runAsGroup(), other.runAsGroup()) && Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.allowPrivilegeEscalation(), other.allowPrivilegeEscalation()) && Objects.equals(this.readOnlyRootFilesystem(), other.readOnlyRootFilesystem()) && Objects.equals(this.runAsNonRoot(), other.runAsNonRoot());
    }

    public final String toString() {
        return ToString.builder((String)"EksContainerSecurityContext").add("RunAsUser", (Object)this.runAsUser()).add("RunAsGroup", (Object)this.runAsGroup()).add("Privileged", (Object)this.privileged()).add("AllowPrivilegeEscalation", (Object)this.allowPrivilegeEscalation()).add("ReadOnlyRootFilesystem", (Object)this.readOnlyRootFilesystem()).add("RunAsNonRoot", (Object)this.runAsNonRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runAsUser": {
                return Optional.ofNullable(clazz.cast(this.runAsUser()));
            }
            case "runAsGroup": {
                return Optional.ofNullable(clazz.cast(this.runAsGroup()));
            }
            case "privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "allowPrivilegeEscalation": {
                return Optional.ofNullable(clazz.cast(this.allowPrivilegeEscalation()));
            }
            case "readOnlyRootFilesystem": {
                return Optional.ofNullable(clazz.cast(this.readOnlyRootFilesystem()));
            }
            case "runAsNonRoot": {
                return Optional.ofNullable(clazz.cast(this.runAsNonRoot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksContainerSecurityContext, T> g) {
        return obj -> g.apply((EksContainerSecurityContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long runAsUser;
        private Long runAsGroup;
        private Boolean privileged;
        private Boolean allowPrivilegeEscalation;
        private Boolean readOnlyRootFilesystem;
        private Boolean runAsNonRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(EksContainerSecurityContext model) {
            this.runAsUser(model.runAsUser);
            this.runAsGroup(model.runAsGroup);
            this.privileged(model.privileged);
            this.allowPrivilegeEscalation(model.allowPrivilegeEscalation);
            this.readOnlyRootFilesystem(model.readOnlyRootFilesystem);
            this.runAsNonRoot(model.runAsNonRoot);
        }

        public final Long getRunAsUser() {
            return this.runAsUser;
        }

        public final void setRunAsUser(Long runAsUser) {
            this.runAsUser = runAsUser;
        }

        @Override
        public final Builder runAsUser(Long runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public final Long getRunAsGroup() {
            return this.runAsGroup;
        }

        public final void setRunAsGroup(Long runAsGroup) {
            this.runAsGroup = runAsGroup;
        }

        @Override
        public final Builder runAsGroup(Long runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getAllowPrivilegeEscalation() {
            return this.allowPrivilegeEscalation;
        }

        public final void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        }

        @Override
        public final Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        public final Boolean getReadOnlyRootFilesystem() {
            return this.readOnlyRootFilesystem;
        }

        public final void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        }

        @Override
        public final Builder readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
            return this;
        }

        public final Boolean getRunAsNonRoot() {
            return this.runAsNonRoot;
        }

        public final void setRunAsNonRoot(Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
        }

        @Override
        public final Builder runAsNonRoot(Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
            return this;
        }

        public EksContainerSecurityContext build() {
            return new EksContainerSecurityContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksContainerSecurityContext> {
        public Builder runAsUser(Long var1);

        public Builder runAsGroup(Long var1);

        public Builder privileged(Boolean var1);

        public Builder allowPrivilegeEscalation(Boolean var1);

        public Builder readOnlyRootFilesystem(Boolean var1);

        public Builder runAsNonRoot(Boolean var1);
    }
}

