/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.ProtectedResourceConditions;
import software.amazon.awssdk.services.backup.model.SensitiveStringMapCopier;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTestingSelectionForCreate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreTestingSelectionForCreate> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::iamRoleArn)).setter(RestoreTestingSelectionForCreate.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<String>> PROTECTED_RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtectedResourceArns").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::protectedResourceArns)).setter(RestoreTestingSelectionForCreate.setter(Builder::protectedResourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProtectedResourceConditions> PROTECTED_RESOURCE_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtectedResourceConditions").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::protectedResourceConditions)).setter(RestoreTestingSelectionForCreate.setter(Builder::protectedResourceConditions)).constructor(ProtectedResourceConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceConditions").build()}).build();
    private static final SdkField<String> PROTECTED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectedResourceType").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::protectedResourceType)).setter(RestoreTestingSelectionForCreate.setter(Builder::protectedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceType").build()}).build();
    private static final SdkField<Map<String, String>> RESTORE_METADATA_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RestoreMetadataOverrides").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::restoreMetadataOverrides)).setter(RestoreTestingSelectionForCreate.setter(Builder::restoreMetadataOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadataOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreTestingSelectionName").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::restoreTestingSelectionName)).setter(RestoreTestingSelectionForCreate.setter(Builder::restoreTestingSelectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelectionName").build()}).build();
    private static final SdkField<Integer> VALIDATION_WINDOW_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValidationWindowHours").getter(RestoreTestingSelectionForCreate.getter(RestoreTestingSelectionForCreate::validationWindowHours)).setter(RestoreTestingSelectionForCreate.setter(Builder::validationWindowHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationWindowHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD, PROTECTED_RESOURCE_ARNS_FIELD, PROTECTED_RESOURCE_CONDITIONS_FIELD, PROTECTED_RESOURCE_TYPE_FIELD, RESTORE_METADATA_OVERRIDES_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD, VALIDATION_WINDOW_HOURS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String iamRoleArn;
    private final List<String> protectedResourceArns;
    private final ProtectedResourceConditions protectedResourceConditions;
    private final String protectedResourceType;
    private final Map<String, String> restoreMetadataOverrides;
    private final String restoreTestingSelectionName;
    private final Integer validationWindowHours;

    private RestoreTestingSelectionForCreate(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.protectedResourceArns = builder.protectedResourceArns;
        this.protectedResourceConditions = builder.protectedResourceConditions;
        this.protectedResourceType = builder.protectedResourceType;
        this.restoreMetadataOverrides = builder.restoreMetadataOverrides;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
        this.validationWindowHours = builder.validationWindowHours;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasProtectedResourceArns() {
        return this.protectedResourceArns != null && !(this.protectedResourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> protectedResourceArns() {
        return this.protectedResourceArns;
    }

    public final ProtectedResourceConditions protectedResourceConditions() {
        return this.protectedResourceConditions;
    }

    public final String protectedResourceType() {
        return this.protectedResourceType;
    }

    public final boolean hasRestoreMetadataOverrides() {
        return this.restoreMetadataOverrides != null && !(this.restoreMetadataOverrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> restoreMetadataOverrides() {
        return this.restoreMetadataOverrides;
    }

    public final String restoreTestingSelectionName() {
        return this.restoreTestingSelectionName;
    }

    public final Integer validationWindowHours() {
        return this.validationWindowHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtectedResourceArns() ? this.protectedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreMetadataOverrides() ? this.restoreMetadataOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingSelectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationWindowHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingSelectionForCreate)) {
            return false;
        }
        RestoreTestingSelectionForCreate other = (RestoreTestingSelectionForCreate)obj;
        return Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasProtectedResourceArns() == other.hasProtectedResourceArns() && Objects.equals(this.protectedResourceArns(), other.protectedResourceArns()) && Objects.equals(this.protectedResourceConditions(), other.protectedResourceConditions()) && Objects.equals(this.protectedResourceType(), other.protectedResourceType()) && this.hasRestoreMetadataOverrides() == other.hasRestoreMetadataOverrides() && Objects.equals(this.restoreMetadataOverrides(), other.restoreMetadataOverrides()) && Objects.equals(this.restoreTestingSelectionName(), other.restoreTestingSelectionName()) && Objects.equals(this.validationWindowHours(), other.validationWindowHours());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreTestingSelectionForCreate").add("IamRoleArn", (Object)this.iamRoleArn()).add("ProtectedResourceArns", this.hasProtectedResourceArns() ? this.protectedResourceArns() : null).add("ProtectedResourceConditions", (Object)this.protectedResourceConditions()).add("ProtectedResourceType", (Object)this.protectedResourceType()).add("RestoreMetadataOverrides", (Object)(this.restoreMetadataOverrides() == null ? null : "*** Sensitive Data Redacted ***")).add("RestoreTestingSelectionName", (Object)this.restoreTestingSelectionName()).add("ValidationWindowHours", (Object)this.validationWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ProtectedResourceArns": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceArns()));
            }
            case "ProtectedResourceConditions": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceConditions()));
            }
            case "ProtectedResourceType": {
                return Optional.ofNullable(clazz.cast(this.protectedResourceType()));
            }
            case "RestoreMetadataOverrides": {
                return Optional.ofNullable(clazz.cast(this.restoreMetadataOverrides()));
            }
            case "RestoreTestingSelectionName": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingSelectionName()));
            }
            case "ValidationWindowHours": {
                return Optional.ofNullable(clazz.cast(this.validationWindowHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingSelectionForCreate, T> g) {
        return obj -> g.apply((RestoreTestingSelectionForCreate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamRoleArn;
        private List<String> protectedResourceArns = DefaultSdkAutoConstructList.getInstance();
        private ProtectedResourceConditions protectedResourceConditions;
        private String protectedResourceType;
        private Map<String, String> restoreMetadataOverrides = DefaultSdkAutoConstructMap.getInstance();
        private String restoreTestingSelectionName;
        private Integer validationWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingSelectionForCreate model) {
            this.iamRoleArn(model.iamRoleArn);
            this.protectedResourceArns(model.protectedResourceArns);
            this.protectedResourceConditions(model.protectedResourceConditions);
            this.protectedResourceType(model.protectedResourceType);
            this.restoreMetadataOverrides(model.restoreMetadataOverrides);
            this.restoreTestingSelectionName(model.restoreTestingSelectionName);
            this.validationWindowHours(model.validationWindowHours);
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getProtectedResourceArns() {
            if (this.protectedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protectedResourceArns;
        }

        public final void setProtectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
        }

        @Override
        public final Builder protectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceArns(String ... protectedResourceArns) {
            this.protectedResourceArns(Arrays.asList(protectedResourceArns));
            return this;
        }

        public final ProtectedResourceConditions.Builder getProtectedResourceConditions() {
            return this.protectedResourceConditions != null ? this.protectedResourceConditions.toBuilder() : null;
        }

        public final void setProtectedResourceConditions(ProtectedResourceConditions.BuilderImpl protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions != null ? protectedResourceConditions.build() : null;
        }

        @Override
        public final Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        public final String getProtectedResourceType() {
            return this.protectedResourceType;
        }

        public final void setProtectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
        }

        @Override
        public final Builder protectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
            return this;
        }

        public final Map<String, String> getRestoreMetadataOverrides() {
            if (this.restoreMetadataOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.restoreMetadataOverrides;
        }

        public final void setRestoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
        }

        @Override
        public final Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return this.restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        public final Integer getValidationWindowHours() {
            return this.validationWindowHours;
        }

        public final void setValidationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
        }

        @Override
        public final Builder validationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        public RestoreTestingSelectionForCreate build() {
            return new RestoreTestingSelectionForCreate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreTestingSelectionForCreate> {
        public Builder iamRoleArn(String var1);

        public Builder protectedResourceArns(Collection<String> var1);

        public Builder protectedResourceArns(String ... var1);

        public Builder protectedResourceConditions(ProtectedResourceConditions var1);

        default public Builder protectedResourceConditions(Consumer<ProtectedResourceConditions.Builder> protectedResourceConditions) {
            return this.protectedResourceConditions((ProtectedResourceConditions)((ProtectedResourceConditions.Builder)ProtectedResourceConditions.builder().applyMutation(protectedResourceConditions)).build());
        }

        public Builder protectedResourceType(String var1);

        public Builder restoreMetadataOverrides(Map<String, String> var1);

        public Builder restoreTestingSelectionName(String var1);

        public Builder validationWindowHours(Integer var1);
    }
}

