/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information for the calculation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculationConfiguration.Builder, CalculationConfiguration> {
    private static final SdkField<String> CODE_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeBlock").getter(getter(CalculationConfiguration::codeBlock)).setter(setter(Builder::codeBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_BLOCK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codeBlock;

    private CalculationConfiguration(BuilderImpl builder) {
        this.codeBlock = builder.codeBlock;
    }

    /**
     * <p>
     * A string that contains the code for the calculation.
     * </p>
     * 
     * @return A string that contains the code for the calculation.
     */
    public final String codeBlock() {
        return codeBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculationConfiguration)) {
            return false;
        }
        CalculationConfiguration other = (CalculationConfiguration) obj;
        return Objects.equals(codeBlock(), other.codeBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculationConfiguration").add("CodeBlock", codeBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeBlock":
            return Optional.ofNullable(clazz.cast(codeBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CalculationConfiguration, T> g) {
        return obj -> g.apply((CalculationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculationConfiguration> {
        /**
         * <p>
         * A string that contains the code for the calculation.
         * </p>
         * 
         * @param codeBlock
         *        A string that contains the code for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeBlock(String codeBlock);
    }

    static final class BuilderImpl implements Builder {
        private String codeBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculationConfiguration model) {
            codeBlock(model.codeBlock);
        }

        public final String getCodeBlock() {
            return codeBlock;
        }

        public final void setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
        }

        @Override
        public final Builder codeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        @Override
        public CalculationConfiguration build() {
            return new CalculationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
