/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.support.CssImportInspector;
import ro.isdc.wro.model.resource.processor.support.ProcessingCriteria;
import ro.isdc.wro.model.resource.processor.support.ProcessingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public class CssImportPreProcessor
extends AbstractCssImportPreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssImportPreProcessor.class);
    public static final String ALIAS = "cssImport";
    @Inject
    private PreProcessorExecutor preProcessorExecutor;

    @Override
    protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.preProcessorExecutor.processAndMerge(foundImports, ProcessingCriteria.create(ProcessingType.IMPORT_ONLY, false)));
        if (!foundImports.isEmpty()) {
            LOG.debug("Imported resources found : {}", (Object)foundImports.size());
        }
        sb.append(cssContent);
        LOG.debug("importsCollector: {}", foundImports);
        return this.removeImportStatements(sb.toString());
    }

    protected String removeImportStatements(String cssContent) {
        return new CssImportInspector(cssContent).removeImportStatements();
    }
}

