/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.cache.CacheStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCacheStrategy<K, V>
implements CacheStrategy<K, V> {
    public static final String ALIAS = "memory";
    private final Map<K, V> map;

    public MemoryCacheStrategy() {
        this(new HashMap());
    }

    public MemoryCacheStrategy(Map<K, V> cacheHolder) {
        Validate.notNull(cacheHolder, (String)"The cache map cannot be null.", (Object[])new Object[0]);
        this.map = Collections.synchronizedMap(cacheHolder);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }
}

