/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.providers.PooledConnectionProvider;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.Pool;

public class JedisPooled
extends UnifiedJedis {
    public JedisPooled() {
        this("127.0.0.1", 6379);
    }

    public JedisPooled(String url) {
        this(URI.create(url));
    }

    public JedisPooled(String url, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(URI.create(url), sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(String host, int port) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), host, port);
    }

    public JedisPooled(String host, int port, boolean ssl) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), host, port, ssl);
    }

    public JedisPooled(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(String host, int port, String user, String password) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), host, port, user, password);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig) {
        this(poolConfig, "127.0.0.1", 6379);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String url) {
        this(poolConfig, URI.create(url));
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port) {
        this(poolConfig, host, port, 2000);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, boolean ssl) {
        this(poolConfig, host, port, 2000, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, 2000, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, String user, String password) {
        this(poolConfig, host, port, 2000, user, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout) {
        this(poolConfig, host, port, timeout, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, boolean ssl) {
        this(poolConfig, host, port, timeout, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, timeout, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password) {
        this(poolConfig, host, port, timeout, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, boolean ssl) {
        this(poolConfig, host, port, timeout, password, 0, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, timeout, password, 0, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password) {
        this(poolConfig, host, port, timeout, user, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password, boolean ssl) {
        this(poolConfig, host, port, timeout, user, password, 0, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database) {
        this(poolConfig, host, port, timeout, password, database, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database, boolean ssl) {
        this(poolConfig, host, port, timeout, password, database, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, timeout, password, database, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password, int database) {
        this(poolConfig, host, port, timeout, user, password, database, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password, int database, boolean ssl) {
        this(poolConfig, host, port, timeout, user, password, database, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database, String clientName) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, timeout, timeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password, int database, String clientName) {
        this(poolConfig, host, port, timeout, timeout, user, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int timeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, timeout, timeout, user, password, database, clientName, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, null, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, password, database, clientName, ssl, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, 0, user, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, user, password, database, clientName, ssl, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, 0, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, connectionTimeout, soTimeout, infiniteSoTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName) {
        this(new HostAndPort(host, port), (JedisClientConfig)DefaultJedisClientConfig.create(connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, false, null, null, null, null), poolConfig);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(host, port), (JedisClientConfig)DefaultJedisClientConfig.create(connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, null), poolConfig);
    }

    public JedisPooled(URI uri) {
        super(uri);
    }

    public JedisPooled(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(URI uri, int timeout) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), uri, timeout);
    }

    public JedisPooled(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig(), uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri) {
        this(poolConfig, uri, 2000);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri, 2000, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, int timeout) {
        this(poolConfig, uri, timeout, timeout);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri, timeout, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, int connectionTimeout, int soTimeout) {
        this(poolConfig, uri, connectionTimeout, soTimeout, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri, connectionTimeout, soTimeout, 0, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(uri.getHost(), uri.getPort()), (JedisClientConfig)DefaultJedisClientConfig.create(connectionTimeout, soTimeout, infiniteSoTimeout, JedisURIHelper.getUser(uri), JedisURIHelper.getPassword(uri), JedisURIHelper.getDBIndex(uri), null, JedisURIHelper.isRedisSSLScheme(uri), sslSocketFactory, sslParameters, hostnameVerifier, null), poolConfig);
    }

    public JedisPooled(HostAndPort hostAndPort) {
        this(new PooledConnectionProvider(hostAndPort));
    }

    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new PooledConnectionProvider(hostAndPort, clientConfig));
    }

    public JedisPooled(HostAndPort hostAndPort, GenericObjectPoolConfig<Connection> poolConfig) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build(), poolConfig);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(hostAndPort, clientConfig, poolConfig);
    }

    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new PooledConnectionProvider(hostAndPort, clientConfig, poolConfig));
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this(new ConnectionFactory(jedisSocketFactory, clientConfig), poolConfig);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, PooledObjectFactory<Connection> factory) {
        this(factory, poolConfig);
    }

    public JedisPooled(PooledObjectFactory<Connection> factory, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new PooledConnectionProvider(factory, poolConfig));
    }

    public JedisPooled(PooledConnectionProvider provider) {
        super(provider);
    }

    public final Pool<Connection> getPool() {
        return ((PooledConnectionProvider)this.provider).getPool();
    }
}

