/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.lang.ref.WeakReference;
import pl.droidsonroids.gif.ConditionVariable;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.GifViewSavedState;
import pl.droidsonroids.gif.GifViewUtils;
import pl.droidsonroids.gif.InputSource;
import pl.droidsonroids.gif.PlaceholderDrawingSurfaceTextureListener;
import pl.droidsonroids.gif.R;

public class GifTextureView
extends TextureView {
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private final Matrix mTransform = new Matrix();
    private InputSource mInputSource;
    private RenderThread mRenderThread;
    private float mSpeedFactor = 1.0f;
    private GifViewUtils.GifViewAttributes viewAttributes;

    public GifTextureView(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public GifTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public GifTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @RequiresApi(value=21)
    public GifTextureView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs != null) {
            int scaleTypeIndex = attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "scaleType", -1);
            if (scaleTypeIndex >= 0 && scaleTypeIndex < sScaleTypeArray.length) {
                this.mScaleType = sScaleTypeArray[scaleTypeIndex];
            }
            TypedArray textureViewAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.GifTextureView, defStyleAttr, defStyleRes);
            this.mInputSource = GifTextureView.findSource(textureViewAttributes);
            super.setOpaque(textureViewAttributes.getBoolean(R.styleable.GifTextureView_isOpaque, false));
            textureViewAttributes.recycle();
            this.viewAttributes = new GifViewUtils.GifViewAttributes((View)this, attrs, defStyleAttr, defStyleRes);
        } else {
            super.setOpaque(false);
            this.viewAttributes = new GifViewUtils.GifViewAttributes();
        }
        if (!this.isInEditMode()) {
            this.mRenderThread = new RenderThread(this);
            if (this.mInputSource != null) {
                this.mRenderThread.start();
            }
        }
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        throw new UnsupportedOperationException("Changing SurfaceTextureListener is not supported");
    }

    public TextureView.SurfaceTextureListener getSurfaceTextureListener() {
        return null;
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        throw new UnsupportedOperationException("Changing SurfaceTexture is not supported");
    }

    private static InputSource findSource(TypedArray textureViewAttributes) {
        TypedValue value = new TypedValue();
        if (!textureViewAttributes.getValue(R.styleable.GifTextureView_gifSource, value)) {
            return null;
        }
        if (value.resourceId != 0) {
            String resourceTypeName = textureViewAttributes.getResources().getResourceTypeName(value.resourceId);
            if (GifViewUtils.SUPPORTED_RESOURCE_TYPE_NAMES.contains(resourceTypeName)) {
                return new InputSource.ResourcesSource(textureViewAttributes.getResources(), value.resourceId);
            }
            if (!"string".equals(resourceTypeName)) {
                throw new IllegalArgumentException("Expected string, drawable, mipmap or raw resource type. '" + resourceTypeName + "' is not supported");
            }
        }
        return new InputSource.AssetSource(textureViewAttributes.getResources().getAssets(), value.string.toString());
    }

    private void setSuperSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        super.setSurfaceTextureListener(listener);
    }

    public void setOpaque(boolean opaque) {
        if (opaque != this.isOpaque()) {
            super.setOpaque(opaque);
            this.setInputSource(this.mInputSource);
        }
    }

    protected void onDetachedFromWindow() {
        this.mRenderThread.dispose(this, null);
        super.onDetachedFromWindow();
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (surfaceTexture != null) {
            surfaceTexture.release();
        }
    }

    public synchronized void setInputSource(@Nullable InputSource inputSource) {
        this.setInputSource(inputSource, null);
    }

    public synchronized void setInputSource(@Nullable InputSource inputSource, @Nullable PlaceholderDrawListener placeholderDrawListener) {
        this.mRenderThread.dispose(this, placeholderDrawListener);
        try {
            this.mRenderThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mInputSource = inputSource;
        this.mRenderThread = new RenderThread(this);
        if (inputSource != null) {
            this.mRenderThread.start();
        } else {
            this.clearSurface();
        }
    }

    private void clearSurface() {
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (surfaceTexture != null) {
            Surface surface = new Surface(surfaceTexture);
            try {
                surface.unlockCanvasAndPost(surface.lockCanvas(null));
            }
            finally {
                surface.release();
            }
        }
    }

    public void setSpeed(@FloatRange(from=0.0, fromInclusive=false) float factor) {
        this.mSpeedFactor = factor;
        this.mRenderThread.mGifInfoHandle.setSpeedFactor(factor);
    }

    @Nullable
    public IOException getIOException() {
        if (this.mRenderThread.mIOException != null) {
            return this.mRenderThread.mIOException;
        }
        return GifIOException.fromCode(this.mRenderThread.mGifInfoHandle.getNativeErrorCode());
    }

    public void setScaleType(@NonNull ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    private void updateTextureViewSize(GifInfoHandle gifInfoHandle) {
        Matrix transform = new Matrix();
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float scaleX = (float)gifInfoHandle.getWidth() / viewWidth;
        float scaleY = (float)gifInfoHandle.getHeight() / viewHeight;
        RectF src = new RectF(0.0f, 0.0f, (float)gifInfoHandle.getWidth(), (float)gifInfoHandle.getHeight());
        RectF dst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
        switch (this.mScaleType) {
            case CENTER: {
                transform.setScale(scaleX, scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case CENTER_CROP: {
                float scaleRef = 1.0f / Math.min(scaleX, scaleY);
                transform.setScale(scaleRef * scaleX, scaleRef * scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case CENTER_INSIDE: {
                float scaleRef = (float)gifInfoHandle.getWidth() <= viewWidth && (float)gifInfoHandle.getHeight() <= viewHeight ? 1.0f : Math.min(1.0f / scaleX, 1.0f / scaleY);
                transform.setScale(scaleRef * scaleX, scaleRef * scaleY, viewWidth / 2.0f, viewHeight / 2.0f);
                break;
            }
            case FIT_CENTER: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.CENTER);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_END: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.END);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_START: {
                transform.setRectToRect(src, dst, Matrix.ScaleToFit.START);
                transform.preScale(scaleX, scaleY);
                break;
            }
            case FIT_XY: {
                return;
            }
            case MATRIX: {
                transform.set(this.mTransform);
                transform.preScale(scaleX, scaleY);
            }
        }
        super.setTransform(transform);
    }

    public void setImageMatrix(Matrix matrix) {
        this.setTransform(matrix);
    }

    public void setTransform(Matrix transform) {
        this.mTransform.set(transform);
        this.updateTextureViewSize(this.mRenderThread.mGifInfoHandle);
    }

    public Matrix getTransform(Matrix transform) {
        if (transform == null) {
            transform = new Matrix();
        }
        transform.set(this.mTransform);
        return transform;
    }

    public Parcelable onSaveInstanceState() {
        this.mRenderThread.mSavedState = this.mRenderThread.mGifInfoHandle.getSavedState();
        return new GifViewSavedState(super.onSaveInstanceState(), this.viewAttributes.freezesAnimation ? this.mRenderThread.mSavedState : null);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof GifViewSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        GifViewSavedState ss = (GifViewSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mRenderThread.mSavedState = ss.mStates[0];
    }

    public void setFreezesAnimation(boolean freezesAnimation) {
        this.viewAttributes.freezesAnimation = freezesAnimation;
    }

    private static class RenderThread
    extends Thread
    implements TextureView.SurfaceTextureListener {
        final ConditionVariable isSurfaceValid = new ConditionVariable();
        private GifInfoHandle mGifInfoHandle = new GifInfoHandle();
        private IOException mIOException;
        long[] mSavedState;
        private final WeakReference<GifTextureView> mGifTextureViewReference;

        RenderThread(GifTextureView gifTextureView) {
            super("GifRenderThread");
            this.mGifTextureViewReference = new WeakReference<GifTextureView>(gifTextureView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GifTextureView gifTextureView;
            try {
                gifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
                if (gifTextureView == null) {
                    return;
                }
                this.mGifInfoHandle = gifTextureView.mInputSource.open();
                this.mGifInfoHandle.setOptions('\u0001', gifTextureView.isOpaque());
                if (((GifTextureView)gifTextureView).viewAttributes.mLoopCount >= 0) {
                    this.mGifInfoHandle.setLoopCount(((GifTextureView)gifTextureView).viewAttributes.mLoopCount);
                }
            }
            catch (IOException ex) {
                this.mIOException = ex;
                return;
            }
            gifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
            if (gifTextureView == null) {
                this.mGifInfoHandle.recycle();
                return;
            }
            gifTextureView.setSuperSurfaceTextureListener(this);
            boolean isSurfaceAvailable = gifTextureView.isAvailable();
            this.isSurfaceValid.set(isSurfaceAvailable);
            if (isSurfaceAvailable) {
                gifTextureView.post(new Runnable(){

                    @Override
                    public void run() {
                        gifTextureView.updateTextureViewSize(mGifInfoHandle);
                    }
                });
            }
            this.mGifInfoHandle.setSpeedFactor(gifTextureView.mSpeedFactor);
            while (!this.isInterrupted()) {
                try {
                    this.isSurfaceValid.block();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                GifTextureView currentGifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
                if (currentGifTextureView == null) break;
                SurfaceTexture surfaceTexture = currentGifTextureView.getSurfaceTexture();
                if (surfaceTexture == null) continue;
                Surface surface = new Surface(surfaceTexture);
                try {
                    this.mGifInfoHandle.bindSurface(surface, this.mSavedState);
                }
                finally {
                    surface.release();
                }
            }
            this.mGifInfoHandle.recycle();
            this.mGifInfoHandle = new GifInfoHandle();
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            GifTextureView gifTextureView = (GifTextureView)((Object)this.mGifTextureViewReference.get());
            if (gifTextureView != null) {
                gifTextureView.updateTextureViewSize(this.mGifInfoHandle);
            }
            this.isSurfaceValid.open();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            this.isSurfaceValid.close();
            this.mGifInfoHandle.postUnbindSurface();
            this.interrupt();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        void dispose(@NonNull GifTextureView gifTextureView, @Nullable PlaceholderDrawListener drawer) {
            this.isSurfaceValid.close();
            PlaceholderDrawingSurfaceTextureListener listener = drawer != null ? new PlaceholderDrawingSurfaceTextureListener(drawer) : null;
            gifTextureView.setSuperSurfaceTextureListener(listener);
            this.mGifInfoHandle.postUnbindSurface();
            this.interrupt();
        }
    }

    public static interface PlaceholderDrawListener {
        public void onDrawPlaceholder(Canvas var1);
    }
}

